package secrets

import (
	"context"
	"fmt"

	"a.yandex-team.ru/infra/infractl/cli/commands/root"
)

type Credentials struct {
	Username string
	Password string
}

func GiveAccessToProviderByCredentials(ctx context.Context, yavClient *YavClient, creds *Credentials, opts EnsureSecretOptions) (string, error) {
	provider := GetProvider(opts.Provider)
	if provider == nil {
		return "", fmt.Errorf("ask access to unknown provider %q", opts.Provider)
	}
	token, err := provider.GetOAuthTokenByCredentials(ctx, creds)
	if err != nil {
		return "", fmt.Errorf("failed to get oauth %s-token for user %q", opts.Provider, creds.Username)
	}
	secretUUID, err := EnsureSecretForNamespace(ctx, opts)
	if err != nil {
		return "", err
	}
	if err = yavClient.SetSecretField(root.Context, secretUUID, provider.YAVSecretKey, token); err != nil {
		return "", fmt.Errorf("failed to save oauth %s-token in yav for user %q: %v", opts.Provider, creds.Username, err)
	}
	return secretUUID, err
}
