package secrets

import "sync"

var once sync.Once

type registry struct {
	providers map[string]*Provider
}

var r = &registry{
	providers: map[string]*Provider{
		"yp": {
			Name:              "yp",
			YAVSecretKey:      YpTokenYavKey,
			OAuthClientID:     "1ffc8f7c4cc440ebbb2fddd6a333f8a9",
			OAuthClientSecret: "62b2f2dc83944f14a1b9a8e9660d7c59",
			NeedsDelegation:   true,
		},
		"awacs": {
			Name:              "awacs",
			YAVSecretKey:      AwacsTokenYavKey,
			OAuthClientID:     "1ffc8f7c4cc440ebbb2fddd6a333f8a9",
			OAuthClientSecret: "62b2f2dc83944f14a1b9a8e9660d7c59",
			NeedsDelegation:   true,
		},
		"ci": {
			Name:              "ci",
			YAVSecretKey:      "ci.token",
			OAuthClientID:     "1ffc8f7c4cc440ebbb2fddd6a333f8a9",
			OAuthClientSecret: "62b2f2dc83944f14a1b9a8e9660d7c59",
			NeedsDelegation:   false,
		},
		"infractl-ci": {
			Name:              "infractl-ci",
			YAVSecretKey:      "infractl_ci.token",
			OAuthClientID:     "1ffc8f7c4cc440ebbb2fddd6a333f8a9",
			OAuthClientSecret: "62b2f2dc83944f14a1b9a8e9660d7c59",
			NeedsDelegation:   false,
		},
		"docker-registry": {
			Name:              "docker-registry",
			YAVSecretKey:      "infractl_ci.docker_token",
			OAuthClientID:     "1ffc8f7c4cc440ebbb2fddd6a333f8a9",
			OAuthClientSecret: "62b2f2dc83944f14a1b9a8e9660d7c59",
			NeedsDelegation:   false,
		},
	},
}

func GetProvider(name string) *Provider {
	return r.providers[name]
}

// Not used for now. Maybe later in controllers

type Config struct {
	Providers []*Provider `yaml:"providers"`
}

func LoadFromConfig(cfg *Config) {
	once.Do(func() {
		r.providers = make(map[string]*Provider, len(cfg.Providers))
		for _, p := range cfg.Providers {
			r.providers[p.Name] = p
		}
	})
}
