package secrets

import (
	"context"

	"a.yandex-team.ru/library/go/yandex/yav/httpyav"
)

func CheckSecretReadable(
	ctx context.Context,
	client *httpyav.Client,
	uid uint64,
	secret string,
) (bool, error) {
	rsp, err := client.CheckReadAccessRights(ctx, secret, uid)
	if err != nil {
		return false, err
	}
	ok := rsp != nil && rsp.Access == "allowed"
	return ok, nil
}
