# Архитектура и основные понятия

## Шаг 1. PaaS или IaaS

InfraCTL предоставляет две основных функциональных возможности:

* **Платформа управления микросервисами (paas)** - позволяет оперировать сущностью микросервиса на абстрактном уровне, скрывая большинство деталей, предоставляя простые инструменты и один файл спецификации.
* **Платформа управления инфраструктурой (iaas)** - позволяет управлять инфраструктурными сервисами, описывая каждый сервис в отдельных отдельный файлах спецификации.

_Забегая вперед стоит сказать, эти подходы можно комбинировать._

**Микросервис** - единица управления, создается, управляется и деплоится независимо от других, предоставляет api и/или реализует фоновые службы, имеет документацию, мониторинги и т.д. Обычно ограничен рамками нескольких доменных сущностей и их управлением. 

**Инфраструктурные сервисы** - Managed Service for PostgreSQL, Y.Deploy, Nanny, CI/CD, Juggler, The Monitoring, Warden, YT, Error booster, Awacs, Object Storage, Identity and Access Management и другие.

**Спецификация** - файл, обычно в формате yaml/toml/json декларативно описывающий целевое состояние сервиса/микросервиса.

### Выбор

Когда следует выбирать **PaaS**:
* У вас микросервисная архитектура и нет своей платформы.
* У вас множество типовых сервисов.
* Вам необходимо быстро добавлять новые функциональные возможности и запускать новые продукты.
* Вам необходимо снизить расходы на devops.

Когда следует выбирать **IaaS**:
* У вас небольшое количество сервисов, новые практически не появляются.
* У вас все сервисы как снежинки, все разные.
* У вас сложная предметная область, важен контроль всех параметров инфраструктуры.
* Вы хотите хранить спецификации инфраструктуры в системе контроля версий.


## Шаг 2. Описание целевого состояния и iAd

![step-1](https://nda.ya.ru/t/s-la_Ozo4ZRTtm)

Для создания нового микросервиса или инфраструктурного сервиса, достаточно в директории проекта создать файлы спецификации, описывающие целевое состояние. Создать данные файлы можно вручную, сгенерировать или попросить утилиту `infractl` создать дефолтные для дальнейшего редактирования.

В данном примере файл `service.toml` отвечает за описание микросервиса и для использования `платформы управления микросервисами` **достаточно только его**. 

Файли в директории `infra` описывают инфраструктурные сервисы, каждый по отдельности. Они приведены в `amazing-app` для примера.

Файл `a.yaml` будет содержать CI/CD флоу, запускающий процессы релиза или отката целевого состояния инфраструктуры. Помимо версионирования ваших изменений, управление инфраструктурой через стандартные средства CI/CD позволяют вам дополнить этот процесс уведомлениями, проверками и мониторингами, и другими шагами.

_Стоит заметить, что релиз изменений инфраструктуры можно запускать как вместе, так и отдельно с релизом вашего приложения._

### iAd vs iAc

**Infrastructure as data (iAd)** - это декларативный подход к инфраструктуре, то есть вы говорите, что хотите, без указания точных действий или шагов для достижения этого. Спецификации передаются и выполняются API, центральным сервисом, а не человеком. И знаете, что еще? Нам все равно, как выполняется эта просьба: важно только то, что она выполняется точно.

**Infrastructure as code (iAc)** - для сравнения, это чаще декларативный подход к инфраструктуре, с той лишь разницей, что наши спецификации могут содержать шаги или точные действия, которые необходимо передать команде, которая выполнит нашу просьбу. Так же `iAc` зачастую может быть представлен императивно, описывая инфраструктуру кодом.

## Шаг 3. Переход к целевому состоянию

![step-2](https://nda.ya.ru/t/uxYZrX304Xjbpj)

Есть несколько способов, **применить сделанные нами изменения** к инфраструктуре:
1. Использовать сгенерированное CI/CD флоу для релиза/отката только инфраструктуры.
1. Использовать другое сгенерированное CI/CD флоу для релиза/отката инфраструктуры и приложения последовательно.
1. Использовать утилиту `infractl` и в обход CI/CD флоу применить изменения.

_Какой способ выбрать, зависит от ваших потребностей (или доступности CI/CD системы). Наши коллеги из Такси, коллеги из других компаний, выбирают вариант 2 как более универсальный для "простых случаев"._

**InfraCTL platform** состоит из следующих компонентов:
* `Kubernetes API server` - единый gateway принимающий все запросы и делегирующий выполнение контроллерам.
* `PaaS controller` - контроллер отвечающий за платформу управления микросервисами, он спецификации service.toml создает детальные спецификации для каждой системы, реализует основные функции управления.
* `IaaS controllers` - множество контроллеров, провайдеры, отвечающие за конкретные инфраструктурные сервисы и непрерывно (где это применимо) приводящие сервисы к целевому состоянию.
