# Проектная модель

Проектная модель описывает какие сущности и как будет созданы при использовании платформы управления микросервисами.

## Структура

Место сущности микросервис в иерархической/вертикальной структуре компании.

![structure](https://nda.ya.ru/t/O3_6LjTG4XxCXG)

### Namespace/Department

Namespace/Department - корень структуры микросервисов, может отражать бизнес-юнит, подразделение или даже небольшой отдел/команду. 

Основное предназначение - служить зонтиком для группировки "технологически" схожих, типовых микросервисов.

На уровне Namespace можно задавать:
* регистрировать свои спецификации микросервиса и контроллеры по управлению ими.
* типы микросервисов для кодогенерации и быстрого создания по шаблону.
* определять релизные флоу.
* определять общие настройки для микросервиса.
* управлять ресурсами и выступать их донором для микросервисов, устанавливать лимиты.

Примеры: 
* Такси, Маркет, Вертикали на данном уровне регистрируют свои PaaS решения.
* Команда X на данном уровне создает шаблон микросервиса, кастомные CI/CD флоу и базовые настройки.

### Project/Product

Project/Product - логический уровень для группировки микросервисов по продуктам, проектам, командам в рамках namespace.

Основное предназначение - аккумулировать ресурсы и распределять среди микросервисов.

На уровне Project можно задавать:
* определять релизные флоу.
* определять общие настройки для микросервиса.
* управлять ресурсами и выступать их донором для микросервисов, устанавливать лимиты.

### Team

Team - команда работающая над микросервисом.

Основное предназначение - выступать в роли ответственных за сервис, настраивать права доступа.

Команда может быть привязана к любой сущности, тем самым можно назначать ответственных на любом уровне вертикальной структуры и права будут каскадированы вниз.

## Сервис провайдеры

Микросервис - агрегирующая сущность, все проекты в сервис провайдерах создаются относительно ее.

![providers](https://nda.ya.ru/t/Xl6IfteZ4XxCY7)

При создание микросервиса, будут созданы и связаны все необходимые проекты в сервис провайдерах, для последующего управления, назначения прав на все системы сразу, удаления.

## Система лейблов и тегов

**Лейблы** используются для отображения "быстрой" информации о сервисе, в каталоге и на дашборде. Лейблы заранее определены, могут иметь статус. По лейблам также можно осуществлять поиск и группировку.

Регистрировать новые пользователь самостоятельно не может.

Пример простых информационных лейблов:
- Облако: rtc, yc, aws
- Язык программирования
- Tier
- SOX
- Версия service.toml

Пример лейблов со статусом (красный, желтый, зеленый):
- Статус живости сервиса
- 999
- SLA
- Security risks

_Для команд лейблы полезны для количественного анализа своего парка микросервисов_

**Теги** используют для связывания, группировки и поиска микросервисов. Теги задаются пользователями в пределах своего namespace.

Помимо создания новых тегов, в роли тегов могут выступать атрибуты микросервиса, такие как версия service.toml, дежурные, команда, наличие инфраструктурных компонентов, базовые настройки сервиса (например: наличие tvm) и другие.

С точки зрения возможностей поиска и группировки, лейблы и теги не отличаются друг от друга и позволяют настраивать вид каталога (отображаемые микросервисы) под любые задачи, сохранять запросы в избранное для быстрого доступа.

_Для команды infractl лейблы и теги полезны для количественного анализа микросервисов, построения метрик и дашбордов_