import os

import json
import yaml
import kubernetes as k8s


HOST = 'https://k.yandex-team.ru'
WEBAUTH_UNAUTHORIZED_ERROR = 'You are not authorized to access this resource.'
OAUTH_URL = 'https://oauth.yandex-team.ru/authorize?response_type=token&client_id=141d6d975f6049789ba7c78bf82ada5d'

DEPLOY_STAGE_YAML = './deploystage.yaml'

GROUP = 'k.yandex-team.ru'
API_VERSION = 'v1'
NAMESPACE = 'infractl-demo-ns'
PLURAL = 'deploystages'


def fatal(msg):
    print(msg)
    raise SystemExit(123)


def already_exists(e):
    try:
        b = json.loads(e.body)
        return b.get('reason') == 'AlreadyExists'
    except Exception:
        return False


def get_k8s_api():
    token = os.getenv('KUBE_TOKEN')
    if not token:
        fatal('OAuth token is not given. Take it from {} and put it into KUBE_TOKEN env variable'.format(OAUTH_URL))

    cfg = k8s.client.Configuration(
        host=HOST,
        api_key={'authorization': token},
        api_key_prefix={'authorization': 'Bearer'},
    )
    client = k8s.client.ApiClient(cfg)
    return k8s.client.CustomObjectsApi(client)


def create(d):
    k8s_api = get_k8s_api()
    try:
        k8s_api.create_namespaced_custom_object(
            group=GROUP,
            version=API_VERSION,
            namespace=NAMESPACE,
            plural=PLURAL,
            body=d
        )
    except k8s.client.exceptions.ApiException as e:
        if e.status != 409:
            fatal('Failed to create deploystage "{}": {}'.format(d['metadata']['name'], str(e)))
        if already_exists(e):
            print('Deploystage "{}" already exists'.format(d['metadata']['name']))
            return
        fatal('Conflict when creating deploystage "{}": {}'.format(d['metadata']['name'], e))


def get(name):
    k8s_api = get_k8s_api()
    try:
        k8s_api.get_namespaced_custom_object(
            group=GROUP,
            version=API_VERSION,
            namespace=NAMESPACE,
            plural=PLURAL,
            name=name
        )
    except k8s.client.exceptions.ApiException as e:
        if e.status == 404:
            fatal('Deploystage "{}" not found'.format(name))
        fatal('Failed to get deploystage "{}": {}'.format(name, e))


def main():
    with open(DEPLOY_STAGE_YAML) as f:
        d = yaml.safe_load(f)
        create(d)
        get(d['metadata']['name'])


if __name__ == '__main__':
    main()
