package main

import (
	"errors"
	"fmt"
)

var (
	ErrorNonJSON         = errors.New("only JSON response can be returned")
	ErrorNoAuthorization = errors.New("authorization header not given")
	ErrorInvalidMethod   = errors.New("invalid authorization header format")
)

func ErrorUserInfoFailed(err error) error {
	return fmt.Errorf("cannot get user info: %w", err)
}
