package awacsutil

import (
	"context"

	"a.yandex-team.ru/infra/awacs/clients/go/awacs"
	awacsapi "a.yandex-team.ru/infra/awacs/proto"
)

func GetUpstream(
	ctx context.Context,
	client awacs.Client,
	namespace, id string,
) (*awacsapi.Upstream, error) {
	getUpstreamRequest := &awacsapi.GetUpstreamRequest{
		Id:          id,
		NamespaceId: namespace,
		Consistency: awacsapi.ConsistencyLevel_STRONG,
	}
	response, err := client.GetUpstream(ctx, getUpstreamRequest)
	if err != nil {
		return nil, awacs.IgnoreNotFound(err)
	}
	return response.Upstream, nil
}

func GetBackend(
	ctx context.Context,
	client awacs.Client,
	namespace, id string,
) (*awacsapi.Backend, error) {
	getBackendRequest := &awacsapi.GetBackendRequest{
		Id:          id,
		NamespaceId: namespace,
		Consistency: awacsapi.ConsistencyLevel_STRONG,
	}
	response, err := client.GetBackend(ctx, getBackendRequest)
	if err != nil {
		return nil, awacs.IgnoreNotFound(err)
	}
	return response.Backend, nil
}
