package conditionchecker

import (
	"fmt"
	"log"
	"time"
)

type ConditionChecker interface {
	ConditionMet() (bool, string, error)
}

func Wait(checker ConditionChecker, timeout time.Duration) error {
	var timeoutCh <-chan time.Time = nil
	if timeout != time.Duration(0) {
		timeoutCh = time.After(timeout)
	}

	for {
		select {
		case <-time.After(5 * time.Second):
			met, reason, err := checker.ConditionMet()
			if err != nil {
				return err
			}
			log.Println(reason)
			if met {
				return nil
			}
		case <-timeoutCh:
			return fmt.Errorf("waiting timeout exceeded (%.0fs)", timeout.Seconds())
		}
	}
}
