package oauthutil

import (
	"context"
	"fmt"
	"log"
	"os"

	"a.yandex-team.ru/infra/infractl/internal/environs"
	"a.yandex-team.ru/library/go/yandex/oauth"
)

const InfractlTokenEnvVarName = "INFRACTL_TOKEN"

func GetToken(ctx context.Context, envVarName string) (string, error) {
	environ := environs.GetCurrentEnviron()
	return GetTokenForEnviron(ctx, environ, envVarName)
}

func GetTokenForEnviron(ctx context.Context, environ *environs.Environ, envVarName string) (string, error) {
	if token := os.Getenv(envVarName); len(token) != 0 {
		return token, nil
	}

	token, err := oauth.GetTokenBySSH(ctx, environ.OAuthClientID, environ.OAuthClientSecret)
	if err != nil {
		return "", fmt.Errorf("cannot get token from ssh keys: %w\n"+
			"Please follow the instructions in https://docs.yandex-team.ru/infractl/troubleshooting#k8s-token-fail", err)
	}
	return token, nil
}

func MustGetToken(ctx context.Context, envVarName string) string {
	token, err := GetToken(ctx, envVarName)
	if err != nil {
		log.Fatal(err)
	}

	return token
}
