package deploystage

import (
	"context"
	"fmt"
	"net/http"

	"github.com/go-logr/logr"
	corev1 "k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/types"
	"sigs.k8s.io/controller-runtime/pkg/webhook/admission"

	dv1 "a.yandex-team.ru/infra/infractl/controllers/deploy/api/stage/v1"
	"a.yandex-team.ru/infra/infractl/internal/labels"
	"a.yandex-team.ru/infra/infractl/internal/validation"
)

func (v *Validator) validateStage(
	ctx context.Context,
	log logr.Logger,
	curStage, kStage *dv1.DeployStage,
) admission.Response {
	ns := &corev1.Namespace{}
	if err := v.Client.Get(ctx, types.NamespacedName{Name: kStage.GetNamespace()}, ns); err != nil {
		return admission.Errored(http.StatusBadRequest, fmt.Errorf("failed to get namespace %q: %w", kStage.GetName(), err))
	}
	abcSlug := ns.Labels[labels.ABC]
	isValid, msg, err := validation.ValidateStage(ctx, log, v.DeployClient, v.AbcClient, abcSlug, curStage, kStage)

	if err != nil {
		return admission.Errored(http.StatusBadRequest, fmt.Errorf("failed to validate deploy stage fqid: %w", err))
	}
	if !isValid {
		return admission.Denied(msg)
	}
	return admission.Allowed("")
}
