package deploystage

import (
	"context"

	"github.com/go-logr/logr"
	"k8s.io/apimachinery/pkg/util/sets"
	"sigs.k8s.io/controller-runtime/pkg/client"
	"sigs.k8s.io/controller-runtime/pkg/webhook/admission"

	dv1 "a.yandex-team.ru/infra/infractl/controllers/deploy/api/stage/v1"
	"a.yandex-team.ru/infra/infractl/webhooks/internal/secrets"
)

func (v *Validator) CollectSecrets(obj client.Object) sets.String {
	stage, ok := obj.(*dv1.DeployStage)
	if !ok {
		return sets.String{}
	}
	return stage.CollectSecrets()
}

func (v *Validator) GetTvmID() uint64 {
	return v.TvmID
}

func (v *Validator) validateSecrets(
	ctx context.Context,
	log logr.Logger,
	curStage, kStage *dv1.DeployStage,
) admission.Response {
	return secrets.ValidateSecrets(ctx, log, v, curStage, kStage)
}
