package objects

import (
	"context"
	"fmt"
	"net/http"
	"reflect"

	"github.com/go-logr/logr"
	"k8s.io/apimachinery/pkg/types"
	"sigs.k8s.io/controller-runtime/pkg/client"
	"sigs.k8s.io/controller-runtime/pkg/webhook/admission"
)

func LoadCurrent(ctx context.Context, log logr.Logger, kubeclient client.Client, newObject client.Object) (client.Object, admission.Response) {
	valType := reflect.ValueOf(newObject).Elem()
	current := reflect.New(valType.Type()).Interface().(client.Object)
	err := kubeclient.Get(ctx, types.NamespacedName{Namespace: newObject.GetNamespace(), Name: newObject.GetName()}, current)
	switch {
	case err != nil && client.IgnoreNotFound(err) == nil:
		return nil, admission.Allowed("")
	case err != nil:
		log.Error(err, "failed to get object")
		return nil, admission.Errored(
			http.StatusBadRequest,
			fmt.Errorf(
				"failed to get object %s/%s: %w",
				newObject.GetNamespace(),
				newObject.GetName(),
				err,
			),
		)
	default:
		return current, admission.Allowed("")
	}
}
