package secrets

import (
	"fmt"
	"log"
	"net"
	"net/url"
	"sync"

	"a.yandex-team.ru/library/go/yandex/blackbox/httpbb"
)

var ipOnce sync.Once
var ip string

func GetIP() string {
	ipOnce.Do(func() {
		bbURL, err := url.Parse(httpbb.IntranetEnvironment.BlackboxHost)
		if err != nil {
			log.Fatalf("Failed to parse blackbox address: %v", err)
		}

		bbHost := fmt.Sprintf("%v:443", bbURL.Host)

		conn, err := net.Dial("udp", bbHost)
		if err != nil {
			log.Fatalf("Failed to create socket to blackbox: %v", err)
		}
		defer func(conn net.Conn) {
			_ = conn.Close()
		}(conn)

		ip = conn.LocalAddr().(*net.UDPAddr).IP.String()
	})

	return ip
}
