package runtime

import (
	"context"

	"github.com/go-logr/logr"
	"k8s.io/apimachinery/pkg/util/sets"
	"sigs.k8s.io/controller-runtime/pkg/client"
	"sigs.k8s.io/controller-runtime/pkg/webhook/admission"

	rv1 "a.yandex-team.ru/infra/infractl/controllers/runtime/api/v1"
	"a.yandex-team.ru/infra/infractl/webhooks/internal/secrets"
)

func (v *Validator) CollectSecrets(obj client.Object) sets.String {
	runtime, ok := obj.(*rv1.Runtime)
	if !ok {
		return sets.String{}
	}

	return runtime.CollectSecrets()
}

func (v *Validator) GetTvmID() uint64 {
	return v.TvmID
}

func (v *Validator) validateSecrets(
	ctx context.Context,
	log logr.Logger,
	curRuntime, kRuntime *rv1.Runtime,
) admission.Response {
	return secrets.ValidateSecrets(ctx, log, v, curRuntime, kRuntime)
}
