# Формат конфигураций

Конфигурация — это JSON-файл, содержащий информацию о состоянии, в которое необходимо перевести [задачи](objects/tasks.md) перечисленных [слотов](objects/slot.md).

Выделяют следующие типы конфигураций:

- [Применимые](#instance-config) — могут использоваться на находящихся под управлением {{ product }}а хостах.
- [Неприменимые](#topological-config) — выполняют функцию шаблонов. Перед использованием на хостах, находящихся по управлением {{ product }}а, должны быть преобразованы в применимые.


## Применимые {#instance-config}

Обобщенный формат применимой конфигурации приведен ниже.

```javascript
[
    {
        "@class" : "<тип конфигурации>",
        "configurationId" : "<идентификатор конфигурации>",
        "slot" : "<идентификатор>",
        "container" : {
            "constraints" : {
                "ограничение" : "<значение 1>",
                "ограничение" : "<значение 2>",
                ...
                "ограничение" : "<значение N>"
            }
        },
        "properties" : {
            "произвольное свойство" : "<значение 1>"
            ...
            "произвольное свойство" : "<значение M>"
        },
        "resources" : {
            "название_ресурса" : {
                "@class" : <тип ресурса>
                "uuid" : "<уникальное имя ресурса>",
                "urls": [<адреса ресурсов>],
                "cached": <true/false>,
                "size" : <размеры>,
                "verification" : {
                    "checksum" : "<контрольная сумма>",
                    "checkPeriod" : "<период обновления>"
                }              
            }
        },
        "timeLimits" : {
            "хук" : {
                "maxRestartPeriodMs" : <время в миллисекундах>,
                "minRestartPeriodMs" : <время в миллисекундах>,
                "maxExecutionTimeMs" : <время в миллисекундах>
                },
            },
        }
]
```

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`@class` | Обязательный | Тип конфигурации.<br/><br/>Применимым (в зависимости от типа [задачи](objects/tasks.md)) могут соответствовать значения:<br/><br/>- <q>ru.yandex.iss.Instance</q> — [Инстанс](objects/tasks.md#instances).<br/>- <q>ru.yandex.iss.Job</q> — [Джоб](objects/tasks.md#job).
`configurationId` | Необязательный | Уникальный идентификатор конфигурации.<br/><br/>Ответственными за обеспечение уникальности являются авторы.<br/><br/>Если не указан, значение генерируется автоматически на стороне {{ product }}a. В данном случае уникальность обеспечивается автоматически. 
`slot` | Обязательный | Идентификатор [слота](objects/slot.md) (см. формат в соответствующем разделе).<br/><br/>Пример:<br/>```no-highlight 2258@ws10-332.sinclair.yandex.net ```

**Объект container**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`container` | Необязательный | Объект, определяющий настройки контейнера Porto, в котором необходимо выполнять действия с [ресурсами](objects/resources.md) (например, количество выделяемой памяти, CPU, и т. д.).<br/><br/>Если ключ не указан, используются системные настройки.
`constraints` | Необязательный | Объект, содержащий список ограничений контейнера, с которыми запускаются ресурсы инстанса или джоба.
`ограничение` | Обязательный (если в конфигурации присутствует объект `constraints`) | Ограничения и свойства контейнера Порто.<br/><br/>Формат указания:<br/>```no-highlight "<имя управляющего файла из контроллера memory, cpu или blkio>" : "<максимальное значение>" ```<br/><br/>Указанные значения заменяют системные для данного управляющего файла.<br/><br/>Примеры пар ключ-значение:<br/>```no-highlight "cpu.smart" : "1" ```<br/><br/>```no-highlight "memory.recharge_on_pgfault" : "1" ```

**Объект properties**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`properties` | Необязательный | Объект, содержащий произвольные свойства.<br/><br/>Используется для применения [наполнителей](#filler). Если множество перечисленных свойств совпадает, то секция заменяется данными из наполнителя.

**Объект resources**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`resources` | Обязательный | Объект, содержащий список [ресурсов](objects/resources.md), необходимых для функционирования инстанса или джоба.<br/><br/>Каждый вложенный объект описывает один ресурс.<br/><br/>Для каждого инстанса или джоба должен быть определен по крайней мере один ресурс, соответствующий хуку <br/>`iss_hook_start`:<br/><br/>Запуск [задачи](objects/tasks.md) ([инстанса](objects/tasks.md#instances) или [Джоб](objects/tasks.md#job)).<br/><br/>В большинстве случаев реализован в виде скрипта.<br/><br/>При успешном получении [ресурса](objects/resources.md), соответствующего данному хуку, {{ product }} выполняет следующие действия:<br/><br/>- (_Для инстансов_) Преобразует соответствующий скрипт в демон в контейнере верхнего уровня.<br/>- Поддерживает в запущенном состоянии.<br/><br/>Объект <q>название_ресурса</q>.
`название_ресурса` | Обязательный (должен быть указан по крайней мере один ресурс, соответствующий [хуку](hooks.md)`iss_hook_start`) | Идентификатор ресурса.<br/><br/>Соответствует имени символьной ссылки на ресурс в каталоге инстанса или джоба.<br/><br/>В качестве значения может быть указан один из [хуков](hooks.md).
`@class` | Обязательный | Тип ресурса.<br/><br/>Возможные значения:<br/><br/>- <q>ru.yandex.iss.Resource</q> — [статический](objects/resources.md#static). Скачивается с одного из [указанных](#urls-desc) адресов и запускается в контейнере инстанса или джоба. Изменение списка статических ресурсов требует перезапуска инстанса или джоба.<br/>- <q>ru.yandex.iss.DynamicResource</q> — [динамический](objects/resources.md#dynamic). Общий ресурс. Используется с хуком `iss_hook_notify`. Позволяет указать ресурсы, переход на которые не требует перезапуска инстанса.
`uuid` | Обязательный (если не указан ключ `checksum`). | Уникальный идентификатор ресурса. Задается пользователем.<br/><br/>Ресурсы, у которых совпадают `uuid` или `checksum`, считаются идентичными.
`urls` | Обязательный | Список адресов, по которым доступны ресурсы.<br/><br/>Поддерживаются протоколы HTTP (схема <q>http</q>) и BitTorrent (схема <q>rbtorrent</q>, поддержана средствами [copier](https://doc.yandex-team.ru/Search/skynet-desc/concepts/public-services_copier.html)).<br/><br/>Могут быть указаны несколько значений (в том числе — с разными схемами). В данном случае будут выполняться последовательные попытки скачать ресурсы по одной из ссылок.<br/><br/>Если один ресурс `uuid` указан для [хоста](term.md#host) более одного раза, а список URL у них различается, то все URL будут иметь одинаковый приоритет (считается, что доступны одни и те же ресурсы).
`cached` | Необязательный | Признак необходимости хранить ресурсы после того, как они перестают использоваться.<br/><br/>Возможные значения:<br/><br/>- <q>false</q> — удалять ресурсы, если они не требуются для дальнейшего функционирования инстанса или джоба.<br/><br/>- <q>true</q> — хранить ресурсы, даже если они не требуются для дальнейшего функционирования инстанса или джоба.<br/><br/>    В данном случае файлы хранятся до окончания дискового пространства в контейнере. При достижении порога в первую очередь удаляются наиболее долго не использовавшиеся файлы наименьшего размера (так как требуют наименьших затрат на скачивание).<br/><br/>По умолчанию (ключ не указан) ресурсы удаляются, если не требуются для дальнейшего функционирования инстанса или джоба.
`size` | Обязательный | Объем памяти, который должны занять ресурсы после скачивания.<br/><br/>Если указано значение, отличное от <q>0</q>, загрузка ресурсов начинается только после того, как зарезервирован указанный объем памяти на хосте. Если реальный размер окажется отличающимся от заявленного, то после скачивания {{ agent }} соответствующим образом обновляет информацию о доступном месте.<br/><br/>Если указано значение <q>0</q>, то место под ресурсы не резервируется, скачивание начинается без проверки.

**Объект verification**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`verification` | Обязательный | Объект с информацией, требуемой для проверки корректности полученного ресурса.
`checksum` | Обязательный (если не указан ключ `uuid`) | Контрольная сумма ресурса.<br/><br/>Возможные значения:<br/><br/>- <q>EMPTY:</q> — не проверять контрольную сумму (используется по умолчанию);<br/>- <q>MD5:<значение></q> — проверять указанную контрольную сумму, полученную по алгоритму MD5.<br/><br/>Ресурсы, у которых совпадают `uuid` или `checksum`, считаются идентичными.
`checkPeriod` | Обязательный(если не указан ключ `uuid`) | Частота, с которой необходимо проверять контрольную сумму ресурсов после скачивания.<br/><br/>Формат указания:<br/>```no-highlight <количество дней>d<количество часов>h<количество минут>m ```<br/>Например, чтобы проверять целостность ресурсов раз в час необходимо указать следующее значение: <q>0d1h0m</q>.<br/><br/>Для отключения регулярной проверки следует указать значение <q>0d0h0m</q> (используется по умолчанию). В данном случае контрольная сумма проверяется единожды (после загрузки).<br/><br/>Настоятельно рекомендуется использовать регулярную проверку ресурсов. В противном случае не гарантируется корректное восстановление сервиса в при нештатных ситуациях.<br/><br/>**Пример**. Хост, находящийся под управлением {{ product }}а, переходит в неработоспособное состояние. Для восстановления необходимо заново установить все приложения. При этом за время, прошедшее с первичной установки, контент, доступный по указанной для ресурса ссылке, изменился. Так как проверка целостности не выполняется, после установки полученного ресурсного файла поведение непредсказуемо.

**Объект timeLimits**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`timeLimits` | Необязательный | Объект, содержащий описание ограничений, накладываемых на время перезапуска и выполнения [хуков](hooks.md).<br/><br/>Каждый вложенный объект описывает ограничения, накладываемые на указанный хук.

**Объект хук**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`хук` | Необязательный | Объект, содержащий временные ограничения на выполнение и перезапуск хука.<br/><br/>Значение должно совпадать с одним из перечисленных в объекте `resources`.<br/><br/>Часть вложенных ключей используется для расчета интервала между перезапуском хуков, который определяется как минимальное из следующих значений:<br/><br/>- $maxRestartPeriodMs$;<br/>    <br/>- $minRestartPeriodMs + restartPeriodScaleMs * (restartPeriodBackoff^{step}) \mbox{ , где}$$step$ — порядковый номер попытки перезапустить хук (для первого запуска равен 0). Значение последовательно увеличивается на 1, пока сохраняется код возврата. При изменение кода возврата $step$ обнуляется.
`restartPeriodScaleMs` | Необязательный | Основа шага, на который необходимо увеличивать время между перезапусками хука. Используется в случае применения формулы, в которой время между перезапусками растет экспоненциально (см. описание объекта `хук`).<br/><br/>Если не указан, то в качестве значения используется <q>0</q>.
`restartPeriodBackoff` | Необязательный | Основа корректирующего коэффициента, применяемого для увеличения времени между перезапусками хука. Используется в случае применения формулы, в которой время между перезапусками растет экспоненциально (см. описание объекта `хук`).<br/><br/>Если не указан, то в качестве значения используется <q>0</q>.
`maxRestartPeriodMs` | Необязательный | Максимальное время между перезапусками хука.<br/><br/>Если не указан, то в качестве значения используется плюс бесконечность.
`minRestartPeriodMs` | Необязательный | Минимальное время между перезапусками хука.<br/><br/>Если заданы ключи `restartPeriodScaleMs` и `restartPeriodBackoff`, то применяется в формуле, в которой время между перезапусками растет экспоненциально (см. описание объекта `хук`). В противном случае минимальное время между перезапусками является фиксированным.
`maxExecutionTimeMs` | Необязательный | Максимальное время (в миллисекундах), в течение которого допустимо выполнение хука.<br/><br/>При достижении данного порога выполнение принудительно прекращается.

> В следующем примере приведена применимая конфигурация для слота <q>2259@sheridan.yandex.ru</q>.
> 
> Параметры cgroup:
> 
> - Родительский cgroup: `/slots/iss-agent`.
> - Максимальный объем используемой памяти: 20 ГБ.
> - Менять владельца памяти на контейнер с данным инстансом при прерывании <q>отказ страницы</q> (page fault).
> 
> В конфигурации определен один ресурс (хук `iss_hook_start`) со следующими параметрами:
> 
> - Уникальный идентификатор ресурса — `ru.yandex.iss.Resource`.
>     
> - URL, по которому доступен ресурс — указан один, `http://kosh.yandex-team.ru/download/files/starter`.
> - Должен сохраняться после того, как перестал использоваться.
> - Контрольная сумма — <q>c8f1f9626698f46f88b6e70b2c6d132d</q>.
> - Частота, с которой необходимо проверять контрольную сумму ресурсов
>     — раз в час.
> 
> ```javascript
> [
>     {
>         "@class" : "ru.yandex.iss.Instance",
>         "slot" : "2259@sheridan.yandex.ru",
>         "container" : {
>             "constraints" : {
>                 "memory.limit_in_bytes" : "20G",
>                 "memory.recharge_on_pgfault" : "1"                
>             },
>         },
>         "resources" : {
>             "iss_hook_start" : {
>                 "@class" : "ru.yandex.iss.Resource"
>                 "uuid" : "iss_hook_start_mollari-1.0",
>                 "urls": ["http://kosh.yandex-team.ru/download/files/starter"],
>                 "cached": true,
>                 "verification" : {
>                     "checksum" : "c8f1f9626698f46f88b6e70b2c6d132d",
>                     "checkPeriod" : "0d1h0m"
>                 },               
>             },
>     }
> ]
> ```


## Неприменимые {#topological-config}

Если часть [конфигурации](objects/configuration.md) (например, [хосты](term.md#host), к которым она применима) регулярно меняется, целесообразно разделять топологическую информацию (о хостах и [слотах](objects/slot.md)) и [ресурсную](objects/resources.md). В данном случае используются неприменимые конфигурации.

Для использования на хостах такие конфигурации накладываются (_мутируют_) на основе совпадения произвольных свойств (задаются в объектах `properties`). В результате формируются [применимые](#instance-config).

Неприменимые конфигурации делятся на следующие типы:

- [Топология](#topology).
- [Наполнитель](#filler).

{% note info %}

Все типы неприменимых конфигураций могут использоваться для модификации отдельных параметров, указанных в применимых.

{% endnote %}


### Топология {#topology}

Содержит топологическую часть конфигурации (сведения о хостах и слотах).

Может использоваться в качестве шаблона для дальнейшего [наполнения](#filler) данными.

Обобщенный формат топологической конфигурации приведен ниже.

```javascript
[
    {
        "@class" : "ru.yandex.iss.TopologicalInstance",
        "slot" : "<идентификатор>",
        "properties" : {
            "произвольное свойство" : "<значение 1>"
            ...
            "произвольное свойство" : "<значение M>"           
        },
    }
]
```

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`@class` | Обязательный | Тип конфигурации.<br/><br/>Топологиям соответствует значение <q>ru.yandex.iss.TopologicalInstance</q>.
`slot` | Обязательный | Идентификатор [слота](objects/slot.md) (см. формат в соответствующем
 разделе).<br/><br/>Пример:<br/>```no-highlight 2258@ws10-332.sinclair.yandex.net ```

**Объект properties**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`properties` | Обязательный | Объект, содержащий произвольные свойства.<br/><br/>Используется для применения [наполнителей](#filler). Если значения ключей совпадают с перечисленными в [наполнителе](#filler), то при мутации данные о слоте дополняются соответствующими сведениями из наполнителя.

### Наполнитель {#filler}

Содержит часть конфигурации, относящуюся к утилитам (сведения об [инстансах](objects/tasks.md#instances) / [Джоб](objects/tasks.md#job) и [ресурсах](objects/resources.md)).

Варианты использования:

- Наполнение [топологий](#topology) данными.
- Шаблон для наполнения топологией.

Предусмотрен механизм наследования. Дочерние наполнители наследуют все свойства, определенные для родительского.

Обобщенный формат наполнителя приведен ниже.

```javascript
[
    {
        "@class" : "ru.yandex.iss.InstanceFiller",
        "name" : "loop-middle-search"
        "filter" : "instance[a_itype_mmeta]",
        "parentFillers" : "default-filler"
        "instance" : {
            "properties" : {
                "произвольное свойство" : "<значение 1>"
                ...
                "произвольное свойство" : "<значение M>"  
            },
            "resources" : {          
            ...
            },
            "timeLimits" : {
            ...
            },
        },
    }
]
```

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`@class` | Обязательный | Тип конфигурации.<br/><br/>Наполнителям соответствует значение <q>ru.yandex.iss.InstanceFiller</q>.
`name` | Обязательный | Уникальное имя наполнителя.
`filter` | Необязательный | Условие, по которому сопоставляются [слоты](objects/slot.md) и наполнители. Подробная информация о фильтрах [приведена в Вики](https://wiki.yandex-team.ru/iss3/Specifications/queries).<br/><br/>Если не указан, правила, указанные в наполнители, применяются ко всем записям, в которых заданы свойства, указанные в объекте properties.
`parentFillers` | Необязательный | Имя родительских наполнителей.<br/><br/>Если указан, недостающие свойства заполняются данными из родительских наполнителей.<br/><br/>Одному наполнителю может быть сопоставлено несколько родительских. При этом родительские не должны переопределять одни и те же свойства дочернего наполнителя.

**Объект instance**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`instance` | Обязательный | Объект, содержащий информацию об инстансе или джобе, который должен быть запущен на указанной группе хостов.

**Объект properties**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`properties` | Обязательный | Объект, содержащий произвольные свойства.<br/><br/>Используется для применения наполнителей. Секции [топологии](#topology) или [применимой конфигурации](#instance-config), в которых перечисленные свойства совпадают с указанными, заменяются данными из наполнителя.<br/><br/>Свойства дочерних наполнителей дополняются указанными для родительских.

**Объект resources**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`resources` | Обязательный | Объект, содержащий список [ресурсов](objects/resources.md), необходимых для функционирования инстанса.<br/><br/>Каждый вложенный объект описывает один [ресурс](term.md#resources).<br/><br/>Формат указания совпадает с используемым в [применимых конфигурациях](#instance-config).

**Объект timeLimits**

**Ключ** | **Признак обязательности** | **Описание**
:--- | :--- | :---
`timeLimits` | Обязательный (если указан тип конфигурации <q>ru.yandex.iss.Job</q>) | Объект, содержащий описание ограничений, накладываемых на время перезапуска и выполнения [хуков](hooks.md).<br/><br/>Каждый вложенный объект описывает ограничения, накладываемые на указанный хук.<br/><br/>Формат указания совпадает с используемым в [применимых конфигурациях](#instance-config).

> ## Пример применения наполнителя к топологии
> 
> Рассмотрим следующую топологию:
> 
> ```javascript
> [
>     {
>         "@class" : "ru.yandex.iss.TopologicalInstance",
>         "slot" : "27777@ws10-332.search.yandex.net",
>         "properties" : {
>             "a_itype_mmeta": "1",
>             "all-tags": "a_itype_mmeta",
>             "port": "27777",
>             "shard-name": "rearr-prod-msuserdata-000",
>             "short-host": "ws10-332"
>         }
>     },
>     {
>         "@class": "ru.yandex.iss.TopologicalInstance",
>         "slot": "27777@ws10-330.search.yandex.net",
>         "properties": {
>             "a_itype_mmeta": "1",
>             "all-tags": "a_itype_mmeta",
>             "port": "27777",
>             "shard-name": "rearr-prod-msuserdata-000",
>             "short-host": "ws10-330"
>         }
>     }
> ]
> ```
> 
> Пусть к ней применен следующий наполнитель:
> 
> ```javascript
> [
>     {
>         "@class" : "ru.yandex.iss.InstanceFiller",
>         "name" : "not-platinum-loop-base-search",
>         "filter" : "instance[properties/a_itype_mmeta]",
>         "instance" : {
>             "properties" : {                
>                 "all-tags": "@{prop(\"properties/all-tags\")} "
>                 },
>             "resources" : {
>                 "apache.ywsearch.cfg" : {
>                     "@class" : "ru.yandex.iss.Resource",
>                     "urls" : ["http://shadow.yandex.ru/res/2258/apache.ywsearch.cfg.120123.netliba"],
>                     "verification" : {
>                         "checksum": "MD5:99300b5d1e10ec1d72cb45d023fe86ac",
>                         "checkPeriod": "0d0h0m"
>                     },
>                 },
>                 "iss_hook_start" : {
>                     "@class" : "ru.yandex.iss.Resource",
>                     "urls" : ["http://minbari.yandex-team.ru/api/iss_hook_start"],
>                     "verification" : {
>                         "checksum" : "MD5:9c3f48a7610df11c9eaefaecd72591a3",
>                         "checkPeriod" : "0d0h0m"
>                     }
>                 }   
>             }
>         }
>     }   
> ]
> ```
> 
> Результатом мутации является следующая применимая конфигурация:
> 
> ```javascript
> [
>     {
>         "@class" : "ru.yandex.iss.Instance",
>         "slot" : "27777@ws10-332.search.yandex.net",
>         "properties" : {
>             "all-tags" : "a_itype_mmeta "
>             "a_itype_mmeta" : "1",
>             "all-tags" : "a_itype_mmeta",
>             "port" : "27777",
>             "shard-name" : "rearr-prod-msuserdata-000",
>             "short-host" : "ws10-332"
>         },
>         "resources" : {
>             "apache.ywsearch.cfg" : {
>                 "@class" : "ru.yandex.iss.Resource",
>                 "urls" : ["http://shadow.yandex.ru/res/2258/apache.ywsearch.cfg.120123.netliba"],
>                 "verification" : {
>                     "checksum" : "MD5:99300b5d1e10ec1d72cb45d023fe86ac"
>                     }
>                 },
>                 "iss_hook_start": {
>                     "@class" : "ru.yandex.iss.Resource",
>                     "urls" : ["http://minbari.yandex-team.ru/api/iss_hook_start"]
>                     "verification" : {
>                         "checksum" : "MD5:9c3f48a7610df11c9eaefaecd72591a3"
>                     },
>                     
>                 }
>          }
>     },
>     {
>         "@class" : "ru.yandex.iss.Instance",
>         "slot" : "27777@ws10-330.search.yandex.net",,
>         "properties" : {
>             "all-tags" : "a_itype_mmeta "
>             "a_itype_mmeta" : "1",
>             "all-tags" : "a_itype_mmeta",
>             "port" : "27777",
>             "shard-name" : "rearr-prod-msuserdata-000",
>             "short-host" : "ws10-330"
>         },
>         "resources" : {
>             "apache.ywsearch.cfg" : {
>                 "@class" : "ru.yandex.iss.Resource",
>                 "urls" : ["http://shadow.yandex.ru/res/2258/apache.ywsearch.cfg.120123.netliba"],
>                 "verification" : {
>                         "checksum" : "MD5:99300b5d1e10ec1d72cb45d023fe86ac"
>                     }
>                 },
>                 "iss_hook_start" : {
>                     "@class" : "ru.yandex.iss.Resource",
>                     "verification" : {
>                         "checksum" : "MD5:9c3f48a7610df11c9eaefaecd72591a3"
>                     },
>                     "urls" : ["http://minbari.yandex-team.ru/api/iss_hook_start"]
>                 }                
>             }
>         }
>     }
> ]
> ```
