# Описание хуков

В таблице ниже приведен список [хуков](objects/resources.md#hooks), используемых в {{ product }}е.

{% note info %}

Примеры реализации хуков доступны в [Sandbox](https://sandbox.yandex-team.ru/sandbox/tasks/view?task_id=41448257&no-cache=1447334457).

{% endnote %}

**Обязательные**

**Имя** | **Назначение**
:--- | :---
`iss_hook_start` | Запуск [задачи](objects/tasks.md) ([инстанса](objects/tasks.md#instances) или [Джоб](objects/tasks.md#job)).<br/><br/>В большинстве случаев реализован в виде скрипта.<br/><br/>При успешном получении [ресурса](objects/resources.md), соответствующего данному хуку, {{ product }} выполняет следующие действия:<br/><br/>- (_Для инстансов_) Преобразует соответствующий скрипт в демон в контейнере верхнего уровня.<br/>- Поддерживает в запущенном состоянии.

**Необязательные**

**Имя** | **Назначение**
:--- | :---
`iss_hook_install` | Модификация каталога, в котором запускается инстанс или джоб, после скачивания ресурсов и до их запуска.<br/><br/>Может использоваться, например, для распаковки архива с ресурсами, выполнения действий, специфичных для сервиса, и т.п.
`iss_hook_uninstall` | Удаление ресурсов, которые более не используются инстансом или джобом.<br/><br/>Позволяет освободить дисковое пространство.
`iss_hook_stop` | Остановка инстанса или джоба указанным способом.<br/><br/>Если указанное действие не может быть выполнено, {{ product }} останавливает инстанс способом, определенным по умолчанию.
`iss_hook_status` | Контроль состояния инстанса или джоба.<br/><br/>Результаты проверки направляется в stderr/stdout.<br/><br/>Примеры использования:<br/><br/>- Xук возвращает значение, отличное от нуля, если инстанс предположительно неработоспособен (например, не отвечает на протяжении 10 секунд после обращения). При наступлении данного события последовательно вызывается хук `iss_hook_stop` и запускается команда `kill -9` для дерева поименованных процессов, соответствующих хуку `iss_hook_start`.<br/>- Хук проверяет ход установки новой версии утилиты на множестве хостов. Установка выполняется одновременно не более чем на десяти хостах. При получении ответа об успешной установке от инстанса или джоба запускается установка новой версии на следующий хост. При возникновении нештатных ситуаций установка на последующие хосты не выполняется.<br/><br/>Частота запуска указывается в [конфигурации](config-types-desc.md).
`iss_hook_validate` | Контроль состояния рабочего каталога инстанса.<br/><br/>Позволяет, например, проверять целостность и корректность хранимых ресурсов.
`iss_hook_notify` | Информирование инстанса или джоба о необходимости переключиться на новые данные. Используется для [динамических ресурсов](objects/resources.md#dynamic).<br/><br/>Используется, например, в Свежести (данные обновляются каждые 30 секунд и переключение не должно приводить к перезапуску инстанса).<br/><br/>Для использования обновленной версии данных необходимо создать новую версию конфигурации. При этом использование хука явно указывает, что не нужно перезапускать инстанса или джоба.
