# Конфигурация

JSON-файл, содержащий информацию о состоянии, в которое необходимо перевести [задачи](tasks.md) перечисленных [слотов](slot.md). Обычно из множества задач, определенных в одной конфигурации, формируются сервисы.

Конфигурации группируются в _семейства_. Чаще всего объединяются конфигурации одного сервиса. Каждому семейству ставится в соответствие уникальный идентификатор. Все версии одной конфигурации относятся к одному семейству.

Каждой конфигурации в рамках семейства можно назначить _тег_ (_определить ветку_). В большинстве случаев ветки используются для указания области применения конфигурации (например, STABLE).

Конфигурациям присваиваются уникальные идентификаторы вида:

```no-highlight
<идентификатор семейства>#<случайная последовательность символов>
```

В качестве последовательности символов в большинстве случаев используется timestamp создания конфигурации.

{% note warning %}

Внесение любых изменений в конфигурацию должно сопровождаться сменой идентификатора.

{% endnote %}

Виды конфигураций:

- **Применимые**.
    
    Могут использоваться непосредственно на находящихся под управлением {{ product }}а хостах.
    
    Содержат информацию, требуемую для приведения одной или многих задач к целевому состоянию, в том числе:
    
    - список слотов, с которыми необходимо выполнить действия;
    - адреса, по которым доступны ресурсы.
    
- **Неприменимые**.
    
    Используются в качестве основы (шаблонов) для формирования применимых конфигураций. Позволяют гибко подходить к управлению слотами и [ресурсами](resources.md). Не могут использоваться непосредственно на находящихся под управлением {{ product }}а хостах. Для использования должны быть предварительно преобразованы в применимые.
    
    Делятся на следующие типы:
    
    - _Топология_ — определяет свойства слотов.
    - _Наполнитель_ (_филлер_) — содержит описание задач. Может также использоваться для модификации применяемых конфигураций (например для внесения массовых правок в текущую).
    
    В качестве шаблона может использоваться любой тип неприменимой конфигурации. Например, если задача сводится к регулярной выкладке разных ресурсов на одни и те же хосты, то в качестве шаблона используется топология. Если одни и те же ресурсы выкладываются на меняющийся список хостов, то в качестве шаблона используется наполнитель.
    

Для подготовки конфигураций можно использовать один из следующих инструментов:

- {{ nanny }}.
- {{ alemate }}.
- {{ searchdms }}.
- API {{ product }}а.

## Узнайте больше

* [Формат конфигураций](../config-types-desc.md)