# Ресурсы

Для перевода множества подконтрольных хостов в заданное состояние используется набор скриптов или утилит — _ресурсов_. Их список задается в [конфигурации](configuration.md).

Типы ресурсов:

- [Статические](#static).
- [Динамические](#dynamic).

Некоторым ресурсам, используемым для выполнения одних и тех же действий (вне зависимости от [задачи](tasks.md)), присваиваются предопределенные имена — [хуки](#hooks).

## Статические {#static}

Изменение версии требует перезапуска задачи. Новым версиям таких ресурсов должны присваиваться уникальные имена (задаются в конфигурации). Для скачивания необходимо предоставить доступ к файлам по новым URL.

## Динамические {#dynamic}

Изменение версии ресурсов не требует перезапуска задачи. Используются, например, в свежести при доставке данных, которые меняются каждые 30 секунд.

При успешном получении данных на хосте вызывается хук `iss_hook_notify` (если определен). В противном случае инстанс или джоб не перезапускается, в обратную связь отправляется сообщение с описанием проблемы и попытка повторяется.

Общий порядок работы с динамическими ресурсами зависит от [текущего](../term.md#current-status) и [целевого](../term.md#goal-state) состояния [задачи](tasks.md).

#### Текущее (или целевое) состояние — <q>PREPARED</q>

Производится попытка скачать динамические ресурсы и создать символьные ссылки.

В случае неудачи в обратную связь отправляется сообщение <q>DYNAMIC_RESOURCE_PREPARATION_FAILURE</q> c описанием проблемы. На следующем цикле синхронизации производится повторная попытка выполнения процедуры.

Ошибки не влияют на подготовку [статических](#static) ресурсов.

#### Текущее состояние — <q>ACTIVE</q>

Порядок работы:

1. (_Опц._) Производится попытка скачать динамические ресурсы и создать символьные ссылки.

    В случае неудачи в обратную связь отправляется сообщение <q>DYNAMIC_RESOURCE_PREPARATION_FAILURE</q> c описанием проблемы. На следующем цикле синхронизации производится повторная попытка выполнения процедуры.
    
1. Выполняется попытка вызвать [хук](../hooks.md)[`iss_hook_notify`](../hooks.md#iss-hook-notify) (если задан).
    
    Если хук не укладывается во временные ограничения или код возврата ненулевой, то в обратную связь отправляется сообщение <q>NOTIFY_HOOK_FAILURE_STATE_INTERCEPTED</q>. Данная ошибка не влияет на состояние задачи. На следующем цикле синхронизации выполняется попытка повторно выполнить действия по переходу к состоянию <q>Active</q>.
    
    В случае успешного выполнения хука повторный вызов выполняется только при изменении списка динамических ресурсов.
    
    {% note info %}
    
    Количество динамических ресурсов не влиет на выполнение [`iss_hook_notify`](../hooks.md#iss-hook-notify). Хук будет выполнен даже в случае, если список динамических ресурсов пуст.
    
    {% endnote %}

## Хук {#hooks}

Произвольный исполняемый файл с одним из предопределенных [имен](../hooks.md). Определяет действия, которые необходимо выполнять с [задачами](tasks.md) в определенных ситуациях. В большинстве случаев в качестве хуков используются Python и bash-скрипты.

Для каждого инстанса должен быть определен по крайней мере один хук — [`iss_hook_start`](../hooks.md#iss-hook-start).

### Узнайте больше

* [Описание хуков](../hooks.md)
