# Задача

Экземпляр приложения, которое необходимо перевести из текущего состояние в _целевое_ (например, запустить или остановить). Каждая задача — это одно приложение, характеризующееся [текущим состоянием](#statuses) на указанном [хосте](../term.md#host).

Все задачи запускаются в контейнерах процессов и изолированы. Обеспечивается системой Porto, реализованной на основе механизма cgroups. Данный подход позволяет регулировать различные аспекты функционирования задачи, например, вводить ограничения на доступный объем памяти, процессорных мощностей и пр. Ограничением является невозможность ставить собственные пакеты.

Типы задач:

- [Инстанс](#instances).
- [Джоб](#job).

### Узнайте больше

- [Описание Porto в Вики](https://wiki.yandex-team.ru/porto/)

## Состояния {#statuses}

Возможные состояния задачи:

- <q>ACTIVE</q> — инстанс или джоб запущен на указанном хосте.

    {% note warning %}

    На каждом хосте единовременно может присутствовать не более одного экземпляра каждого приложения в данном состоянии.

    {% endnote %}

- <q>PREPARED</q> — [ресурсы](resources.md), необходимые для корректного функционирования инстанса или джоба, загружены на хост и готовы к запуску.

    При этом одна из прочих версий приложения на хосте может параллельно находиться в состоянии <q>ACTIVE</q>.

- <q>REMOVED</q> — ресурсы, необходимые для функционирования инстанса или джоба, и созданные задачей файлы удалены с хоста.

- <q>HOOK_SEMI_FAILURE</q> —инстанс или джоб частично неработоспособен.

- <q>HOOK_FAILURE</q> — инстанс или джоб неработоспособен. Для возвращения к состоянию <q>ACTIVE</q> требуется перезапуск.

Перевод новой версии инстанса или джоба в состояние <q>ACTIVE</q> автоматически приводит старый в <q>PREPARED</q>. Это позволяет оперативно переключаться между версиями приложения при нештатных ситуациях.

{% note warning %}

Настоятельно рекомендуется явно указывать, что старая версия сервиса должна быть переведена из <q>ACTIVE</q> в другое состояние (например, <q>REMOVED</q>).

{% endnote %}

## Инстанс {#instances}

Задача, имеющая неограниченное время выполнения. Например, инстанс базового поиска.

В случае перехода в неработоспособное состояние инстансы перезапускаются.

### Узнайте больше

- [Машина состояний Инстанса (в Вики)](https://wiki.yandex-team.ru/ISS3/StateMachine/#instancesm)

## Джоб {#job}

Задача, имеющая ограниченное время выполнения. Например, расчет формулы.

### Узнайте больше

- [Машина состояний джоба (в Вики)](https://wiki.yandex-team.ru/ISS3/StateMachine/#jobsm)
