# Терминология

#### Джоб {#job}

Экземпляр приложения, которое должно быть запущено на [хосте](#host) и имеет ограниченное время работы.

_Пример джоба_: приложение, обеспечивающее расчет формулы ранжирования.

Подробнее в разделе [Джоб](objects/tasks.md#job).

#### Хост {#host}

Сервер, находящийся под управлением {{ product }}а.

#### Инстанс {#instance}

Экземпляр приложения, которое должно быть запущено на [хосте](#host) и имеет неограниченное время работы.

_Пример инстанса_: инстанс Базового поиска.

Подробнее в разделе [Инстанс](objects/tasks.md#instances).

#### Конфигурация {#configuration}

JSON-файл, содержащий формализованное описание совокупности [инстансов](#instance) и [джобов](#job), которые должны быть запущены на одном [хосте](#host).Подробнее в разделе [Конфигурация](objects/configuration.md).

#### Семейство конфигураций {#configurations-family}

Множество [конфигураций](#configuration), относящихся к одному сервису.

#### Идентификатор конфигурации {#configuration-id}

Уникальный идентификатор вида:

```no-highlight
<идентификатор семейства>#<случайная последовательность символов>
```

#### Мутирование {#mutation}

Синоним: наполнение. Преобразование [конфигурации](#configuration) посредством применения заданного набора правил. Результирующая конфигурация относится к [семейству](#configurations-family) исходной.

#### Ресурсы {#resources}

Множество файлов, необходимых для функционирования [инстансов](#instance) и [джобов](#job) в соответствии с правилами [конфигурации](#configuration)._Примеры ресурсов:_ дистрибутив приложения, конфигурационный файл инстанса.Подробнее в разделе [Ресурсы](objects/resources.md).

#### Слот {#slot}

Идентификатор области [хоста](#host), в котором необходимо выполнить действия с [инстансом](#instance).Подробнее в разделе [Слот](objects/slot.md).

#### Целевое состояние {#goal-state}

Состояние к которому необходимо привести [инстанс](#instance) из [текущего](#current-status).Список приведен в разделе [Состояния](objects/tasks.md#statuses).

#### Текущее состояние {#current-status}

Состояние, в котором находится [инстанс](#instance) или [джоб](#job).

Список приведен в разделе [Состояния](objects/tasks.md#statuses).

#### Активация {#activation}

Перевод [инстанса](#instance) в [целевое состояние](#goal-state)<q>ACTIVE</q>.

#### Хук {#hook}

[Ресурс](#resources) с предопределенным (на уровне {{ product }}а) именем. Хуки связываются с ресурсами, выполняющими действия из предопределенного набора (например, запуск). Информация о хуках передается в [конфигурации](#configuration).Подробнее в разделе [Ресурсы](objects/resources.md).
