import json
import re

PROD_HOSTS = "sas1-1885 sas1-1886 sas1-1890".split()
HOST_KEY = ':host'
COLOR_VALUES = "000000 00FF00 0000FF".split()
HOST_COLORS = dict(zip(PROD_HOSTS, COLOR_VALUES))


def load_json(fn):
    data = open(fn, 'r').read()
    return json.loads(data)


def load_prod_hosts():
    return [get_expert_section(load_json(fn + ".json"), fn) for fn in PROD_HOSTS]


def is_expert_key(key):
    return "expert_expert@iss_expert_expert#" in key


def strip_min_max_suffix(key):
    m = re.match(r'^(.+?)(_gmin|_gmax)$', key)
    if m:
        return m.group(1)
    else:
        return key


def get_expert_section(data, host):
    entries = [v for k, v in data['get'].iteritems() if is_expert_key(k) and host in k]
    assert len(entries) == 1
    entry = entries[0]
    entry[HOST_KEY] = host
    return entry


def get_color(host):
    return HOST_COLORS[host]


def get_fqdn(h):
    return h + '.search.yandex.net'


def get_min_max(values):
    min_ = min(values)
    max_ = max(values)

    if min_ == max_:
        if abs(min_) < 0.1:
            delta = 10.0
        else:
            delta = abs(min_) * 5.0
    else:
        delta = (max_ - min_) * 5.0

    return min_ - delta, max_ + delta


def make_metrica_records(hosts_records):
    # key "sas1-1886.search.yandex.net:expert_expert@iss_expert_expert#0aGVxc4PH9B":
    raw_keys = set()
    for r in hosts_records:
        h_values = set(r['values'])
        print r[HOST_KEY], '->', len(h_values), 'values'
        raw_keys |= h_values
    print "raw keys", len(raw_keys)
    common_keys = set(strip_min_max_suffix(k) for k in raw_keys)
    print "common keys", len(common_keys)

    charts = []
    for idx, common_key in enumerate(sorted(common_keys)):
        signals = []
        all_values = []

        for hr in hosts_records:
            host = hr[HOST_KEY]
            fqdn = get_fqdn(host)
            color = get_color(host)

            values = hr['values']

            for metrica_key in values.iterkeys():
                if not metrica_key.startswith(common_key):
                    continue

                all_values.append(values[metrica_key])
                signal = dict(
                    color="#" + color,
                    signal="%s:issexpert_self:%s" % (fqdn, metrica_key),
                    name="%s: %s" % (host, metrica_key)
                )
                signals.append(signal)

        min_, max_ = get_min_max(all_values)
        chart = dict(
            signals=signals,
            maxValue=max_,
            minValue=min_,
            col="left",
            title="[%d] %s" % (idx, common_key),
        )

        charts.append(chart)

    full = {
        "charts": charts,
        "url:show": "http://yasm.yandex-team.ru/panel/ISS-Expert-draft",
        "url:edit": "http://golovan.yandex-team.ru/ambry/?id=_6uSZwb"
    }

    print json.dumps(full, indent=4)

# {
#             "signals": [
#                 {
#                     "color": "#FF4A46",
#                     "signal": "sas1-1885.search.yandex.net:issexpert_self:issexpert-metrics_expert.health.expertise.lag_Value_gmax",
#                     "name": "sas1-1885:"
#                 }
#             ],
#             "maxValue": 500000,
#             "minValue": 0,
#             "col": "left",
#             "title": "health.expertise.lag"
#         }

# "maxValue": 500000,
# "minValue": 0,
# "col": "left",
# "title": "health.expertise.lag"

#
# {
#     "color": "#FF4A46",
#     "signal": "sas1-1885.search.yandex.net:issexpert_self:issexpert-metrics_expert.health.expertise.lag_Value_gmax",
#     "name": "sas1-1885:"
# }



host_records = load_prod_hosts()

print len(host_records)

make_metrica_records(host_records)
