# coding=utf-8
"""
Json generator for Expert monitoring

https://st.yandex-team.ru/SCHEDULERS-250
(former https://st.yandex-team.ru/ISS-1258)
"""
import json
import re

PROD_HOSTS = "sas1-1885 sas1-1886 sas1-1890".split()
HOST_KEY = ':host'
RED = "FF0000"
GREEN = "00FF00"
BLUE = "0000FF"
COLOR_VALUES = (RED, GREEN, BLUE)
HOST_COLORS = dict(zip(PROD_HOSTS, COLOR_VALUES))
LEFT = "left"
RIGHT = "right"

METRIC_LIST = [
    dict(name="issexpert-juggler.rate_OneMinuteRate_gmax",
         label=u"juggler.rate/OneMinuteRate: количество juggler-событий, вычитанных за последнюю минуту. "
               u"Индикатор проблем, связанных с получением данных из logbroker. (KPI)",
         min=0, max=5000,
         column=LEFT),
    dict(name="issexpert-expert.health.expertise.lag_gmax",
         label=u"health.expertise.lag: время в миллисекундах, прошедшее с момента завершения последней экспертизы.",
         min=0, max=1000000.0,
         column=RIGHT),
    dict(name="issexpert-expert.health.events.juggler-lag_gmax",
         label=u"health.events.juggler-lag: время в миллисекундах, прошедшее с последней успешной сессии получения "
               u"juggler-событий из logbroker.",
         min=-1500000000, max=1500000000,
         column=LEFT),
    dict(name="issexpert-expert.lag.expert-juggler_99thPercentile_gmax",
         label=u"lag.expert-juggler/99thPercentile: 99-ый перцентиль времени с момента создания "
               u"последнего принятого juggler-события до получения экспертизы, основанной на данном событии.",
         min=-3522132.35, max=4226558.82,
         column=RIGHT),
    dict(name="issexpert-host-updater.counters.hosts-failed_gmax",
         label=u"host-updater.counters.hosts-failed: количество хостов, для которых по каким-либо причинам "
               u"не удалось получить из OOPS метаданные (стойка, свитч, инвентарный номер etc).",
         min=0, max=5000,
         column=LEFT),
    dict(name="issexpert-host-updater.counters.hosts-restored_gmax",
         label=u"host-updater.counters.hosts-restored: количество failed-хостов, для которых переиспользовались "
               u"уже имеющиеся метаданные.",
         min=0, max=5000,
         column=RIGHT),
    dict(name="issexpert-juggler.lag.juggler_99thPercentile_gmax",
         label=u"lag.juggler/99thPercentile: 99-ый перцентиль времени, затраченного на обработку одного события "
               u"из juggler, от момента получения до момента, когда трансформированное событие было успешно сохранено "
               u"в БД в пределах одной сессии вычитывания данных.",
         min=0, max=5000,
         column=LEFT),
    dict(name="issexpert-alarm",
         label="alarm",
         min=0, max=2,
         column=RIGHT),
    dict(name="issexpert-process.expert.master_gavg",
         label=u"expert.master: 1, если на хосте находится мастер-процесс для процедуры вынесения решений",
         min=0, max=2,
         column=LEFT),
    dict(name="issexpert-process.host-updater.master_gavg",
         label=u"host-updater.master: 1, если на хосте находится мастер-процесс "
               u"для обновления данных по хостам из OOPS",
         min=0, max=2,
         column=RIGHT),
    dict(name="issexpert-process.juggler-consumer.master_gavg",
         label=u"juggler-consumer.master: 1, если на хосте находится мастер-процесс для вычитывания данных из очереди",
         min=0, max=2,
         column=LEFT),
]


def get_fqdn(h):
    return h + '.search.yandex.net'


def make_prod_charts():
    charts = []
    for idx, metrica in enumerate(METRIC_LIST):
        metrica_key = metrica['name']
        label = metrica["label"]
        min_ = metrica["min"]
        max_ = metrica["max"]
        column = metrica["column"]
        title = label  # TODO: make descriptive titles for graphs

        # print "# %d: %s" % (idx, metrica_key)

        signals = []

        for host in PROD_HOSTS:
            # host = hr[HOST_KEY]
            fqdn = get_fqdn(host)
            color = HOST_COLORS[host]

            signal = dict(
                color="#" + color,
                signal="%s:issexpert_self:%s" % (fqdn, metrica_key),
                name=host
            )
            signals.append(signal)

        chart = dict(
            signals=signals,
            maxValue=max_,
            minValue=min_,
            column=column,
            title=title,
        )

        charts.append(chart)

    full = {
        "charts": charts,
        "url:show": "http://yasm.yandex-team.ru/panel/ISS-Expert",
        "url:edit": "http://golovan.yandex-team.ru/ambry/?id=_bGEaVQ",
        "url:details": "https://st.yandex-team.ru/SCHEDULERS-250"
    }

    print json.dumps(full, indent=4)

if __name__ == '__main__':
    make_prod_charts()
