# coding=utf-8
import re
from setuptools import setup


version = 'development'
with open('src/sshforwarder/version.py') as version_file:
    for line in version_file:
        match = re.match(r"^VERSION\s*=\s*\'([^\'\"]+)\'", line)
        if match:
            version = match.group(1)
            break


if __name__ == '__main__':
    setup(
        name='sshforwarder',
        version=version,
        packages=['sshforwarder', ],
        package_dir={'sshforwarder': 'src/sshforwarder'},
        install_requires="ssh==1.8.0",
        author='Denis Barmenkov',
        author_email='abcdenis@yandex-team.ru',
        description='ssh port forwarder',
        zip_safe=False,
        url='https://wiki.yandex-team.ru/iss3',
    )
