# coding=utf-8
"""
utility functions for working with SSH tunnel
"""
import socket
import sys

from sshforwarder import SSHForwarder


DEBUG = False


def debug(msg):
    if DEBUG:
        print "# %s" % (msg, )


def get_random_local_port():
    # http://www.binarytides.com/python-socket-server-code-example/
    # https://www.dnorth.net/2012/03/17/the-port-0-trick/
    # TODO: patch for IPv6 only hosts might be required
    server_socket = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        server_socket.bind(("localhost", 0))
        _address, port = server_socket.getsockname()
        server_socket.close()
        return port
    except socket.error as msg:
        print >> sys.stderr, 'Bind to port 0 failed. Error Code: %s Message %s' % (msg[0], msg[1])
        return None


def create_ssh_tunnel(proxy_host, remote_port, local_port=None, target_host='localhost', user=None):
    if local_port is None:
        local_port = get_random_local_port()
        debug("got free local port: %d" % (local_port, ))

    f = SSHForwarder(proxy_host=proxy_host,
                     remote_port=remote_port,
                     local_port=local_port,
                     target_host=target_host,
                     user=user)
    return f


if __name__ == "__main__":
    print "free local port:", get_random_local_port()
