# coding=utf-8
import iss_thrift3.ttypes as ttypes
from iss_thrift3.IssService import Client

from thriftlite import ThriftServerProxy

from issstate.util import parse_flatten_properties


def get_instance_info(instance):
    service, host = instance.split('@', 1)
    return dict(service=service, host=host, port=service, slot=instance)


class Iss3Info(object):

    DEFAULT_CACHER_URL = 'thrift://iss3.yandex-team.ru:9090'

    def __init__(self, cacher_url=None, timeout=10):
        self.cacher_url = cacher_url
        self.timeout = timeout

        self.proxy = None
        self.create_proxy()

    def create_proxy(self):
        kwargs = dict(client_class=Client)
        if self.cacher_url:
            kwargs['url'] = self.cacher_url
        else:
            kwargs['url'] = self.DEFAULT_CACHER_URL

        if self.timeout:
            kwargs['timeout'] = self.timeout

        self.proxy = ThriftServerProxy(**kwargs)

    def load_branch_configurations(self, branch='CURRENT'):
        response = self.proxy.getBranchHeads(branch)
        return response.configurations

    def get_conf_instances(self, conf_name):
        mvel_filter = 'configuration.id == "%s" && any-instance' % (conf_name, )
        response = self.proxy.query(mvel_filter, ttypes.Portion(0, 2147483647))
        instances = response.result[0].instances
        return [get_instance_info(slot) for slot in instances]

    def get_instance_properties_raw(self, slot, configuration):
        instance_id = ttypes.InstanceId(slot, configuration)
        response = self.proxy.getInstanceProperties(instance_id)
        properties = response.instance.properties
        return parse_flatten_properties(properties)

    def get_instance_properties(self, slot, configuration):
        raw_props = self.get_instance_properties_raw(slot, configuration)
        return raw_props['properties']

    def get_instance_resources(self, slot, configuration):
        raw_props = self.get_instance_properties_raw(slot, configuration)
        return raw_props['resources']
