# coding=utf-8


def split_dict_by_lambda(adict, item_lambda):
    true_items = []
    false_items = []

    for item in adict.iteritems():

        if item_lambda(item):
            true_items.append(item)
        else:
            false_items.append(item)

    return dict(true_items), dict(false_items)


def parse_map_section(raw, plain_key):
    # print 'parse map: %s' % plain_key
    item_filter = lambda item: item[0].startswith(plain_key + '/')
    section_dict, raw = split_dict_by_lambda(raw, item_filter)

    flatten = {}
    for k, v in section_dict.iteritems():
        new_key = k.split('/', 1)[1]
        flatten[new_key] = v

    return parse_flatten_properties(flatten), raw


def parse_list_section(raw, plain_key):
    """
    TODO:
    decide to make all lists unordered
    and collect items without exact indexes
    """
    # print 'parse list: %s' % plain_key
    item_filter = lambda item: item[0].startswith(plain_key + '/')
    list_items_dict, raw = split_dict_by_lambda(raw, item_filter)

    result = []
    for k, v in list_items_dict.iteritems():
        item_index = k.split("/", 1)[-1]

        if not item_index.isdigit():
            raise ValueError("missed index in %s" % k)

        item_index = int(item_index)
        while item_index + 1 > len(result):
            result.append(None)

        result[item_index] = v

    return result, raw


def parse_flatten_properties(props):
    result = dict()
    raw = dict(props)

    # 1. process "@"-prefixed values
    at_keys = [k for k in raw.iterkeys() if k.startswith('@')]

    for key in at_keys:
        plain_key = key[1:]

        if key == '@class':
            result[plain_key] = raw[key]
        else:
            section_type = raw[key]
            if section_type == 'MAP':
                section_dict, raw = parse_map_section(raw, plain_key)
                result[plain_key] = section_dict
            elif section_type == 'LIST':
                section_list, raw = parse_list_section(raw, plain_key)
                result[plain_key] = section_list
            else:
                raise ValueError("invalid section type: %r" % (section_type, ))

        del raw[key]

    # process keys with "/" and process as folders
    while True:
        keys_with_slash = [k for k in raw if '/' in k]
        if not keys_with_slash:
            break

        some_key = keys_with_slash.pop(0)
        folder = some_key.split('/', 1)[0]
        # print 'FOUND FOLDER: %s' % (folder, )

        slashed_dict, raw = parse_map_section(raw, folder)
        result[folder] = slashed_dict

    #add remaining elements to dict
    for k, v in raw.iteritems():
        if k in result:
            print "skip key=%r" % (k, )
            continue
        result[k] = v

    return result
