# coding=utf-8
import re
import unittest
from pprint import pprint as pp
from unittest import TestCase

from issstate import Iss3Info


class TestIssState(TestCase):

    def test_connect(self):
        connect = Iss3Info()
        self.assertIsNotNone(connect.proxy, "unable to connect to default ISS3 cacher")

    def test_load_branch_configurations(self):
        connect = Iss3Info()
        conf_list = connect.load_branch_configurations()
        print 'conf_list:'
        pp(conf_list)
        self.assertGreater(len(conf_list), 0, "no configurations received")

        # check config names
        good_config_name_re = re.compile(r'^[a-zA-Z\-_\d]+#[\da-fA-F]{32}$')
        invalid = [c for c in conf_list if not good_config_name_re.match(c)]
        self.assertEqual(0, len(invalid), 'invalid configuration names: %r' % (invalid, ))

        for prefix in 'priemka-web img-main mmb-web vid-main'.split():
            prefixed = [c for c in conf_list if c.startswith(prefix)]
            print "%r - %d configurations" % (prefix, len(prefixed))
            self.assertGreater(len(prefixed), 0, 'not configurations with prefix %r' % (prefix, ))

    def test_get_instances_and_details(self):
        connect = Iss3Info()
        conf_list = connect.load_branch_configurations()
        conf_name = conf_list.pop()
        print 'any conf:', conf_name
        self.assertNotEqual(conf_name, 'aaa')

        instances = connect.get_conf_instances(conf_name)
        self.assertGreater(len(instances), 0)

        print 'first instances:'
        first = instances[0]
        pp(first)

        slot = first['slot']
        print 'instance slot:', slot

        properties = connect.get_instance_properties(slot, conf_name)
        print "properties:"
        pp(properties)

        self.assertTrue(isinstance(properties, dict))

        resources = connect.get_instance_resources(slot, conf_name)
        print 'resources:'
        pp(resources)

        self.assertTrue(isinstance(properties, dict))


if __name__ == '__main__':
    unittest.main()
