#!/usr/bin/env python2
# coding=utf-8
"""
utility for assemble ISS Agent multi-line log entries into one line and back
"""
import sys


def split_char(line):
    return line[:1], line[1:]


def escape_character(line, char_to_hide):
    return line.replace(char_to_hide, "\\" + char_to_hide)


def unix_split(line, separator):
    result = []
    current = ''
    remainder = line
    while remainder:
        c, remainder = split_char(remainder)
        if c == '\\':
            c2, remainder = split_char(remainder)
            current += c2
        else:
            if c == separator:
                if current:
                    result.append(current)
                    current = ""
            else:
                current += c
    if current:
        result.append(current)
    return result


MODE = sys.argv[1]
assert MODE in ('pack', 'unpack'), "first and the one argument should be 'pack' or 'unpack"

current_block = []
block_count = 0


def flush():
    global current_block
    global block_count

    if current_block:
        block_count += 1

        print '|'.join(current_block)
        current_block = []

line_count = 0

for raw in sys.stdin:
    line_count += 1
    line = raw.splitlines()[0]

    if MODE == 'pack':
        if not line.strip():
            flush()
            continue
        else:
            current_block.append(escape_character(line, "|"))
    else:
        parts = unix_split(line, "|")
        for p in parts:
            print p
        print

if MODE == 'pack':
    flush()
