#!/usr/bin/env python27
import hashlib
import json
import sys
import time


def loads_and_stringify(data):
    """
    load json data and transform unicode to string
      http://stackoverflow.com/questions/956867/
      http://stackoverflow.com/a/6633651/116373
    """
    def _decode_list(data):
        rv = []
        for item in data:
            if isinstance(item, unicode):
                item = item.encode()
            elif isinstance(item, list):
                item = _decode_list(item)
            elif isinstance(item, dict):
                item = _decode_dict(item)
            rv.append(item)
        return rv

    def _decode_dict(data):
        rv = {}
        for key, value in data.iteritems():
            if isinstance(key, unicode):
                key = key.encode()
            if isinstance(value, unicode):
                value = value.encode()
            elif isinstance(value, list):
                value = _decode_list(value)
            elif isinstance(value, dict):
                value = _decode_dict(value)
            rv[key] = value
        return rv

    try:
        return json.loads(data, object_hook=_decode_dict)
    except (ValueError, IndexError) as e:
        raise

try:
    filename = sys.argv[1]
except IndexError:
    filename = None

if filename:
    fh = open(filename)
else:
    fh = sys.stdin

data = fh.read()

if filename:
    fh.close()

# print len(data)

instances = loads_and_stringify(data)
# print instances
instances.sort()  # in some order - it doesn't matter

ts = time.strftime('%Y-%m-%d--%H%M%S', time.localtime(time.time()))

for idx, part in enumerate(instances):
    filename = "%s--%d" % (ts, idx)
    raw_data = json.dumps(part, indent=4)

    fh = open(filename, "w")
    fh.write(raw_data)
    fh.close()

    md5 = hashlib.md5(raw_data)
    print "%s: %s" % (filename, md5.hexdigest())
