import re
import sys
import subprocess

PENDING_GROUPS_COUNT_RE = re.compile('^Total pending groups: (\d+)')
CANCELLED_GROUP_COUNT_RE = re.compile(r'^Total cancelled groups: (\d+)')

collect_lines = False
lines = []

for line in sys.stdin:
    if CANCELLED_GROUP_COUNT_RE.match(line):
        collect_lines = True
        continue

    if collect_lines:
        lines.append(line.splitlines()[0])

    if PENDING_GROUPS_COUNT_RE.match(line):
        break


for line in reversed(lines):
    print line
