#!/usr/bin/env python2.7
# coding=utf-8
"""
Share file to key-value storage

Partial copy and paste from
svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/infra/iss2/iss-acceptance-tests/storage_http.py@1080067
"""
import hashlib
import httplib
import os
import sys


ISS_STORAGE = 'keyvalue.qe.yandex-team.ru'
POST_METHOD = 'POST'
UPLOAD_URL = '/api/versioned/keyvalue'


def get_connection():
    return httplib.HTTPConnection(ISS_STORAGE)


def share_file(file_path):
    basename = os.path.basename(file_path)

    fh = open(file_path, 'rb')
    data = fh.read()
    fh.close()

    connection = get_connection()
    connection.request('POST', UPLOAD_URL + '/' + basename, data)

    response = connection.getresponse()
    file_url = response.read()

    result = {
        'file': file_path,
        'size': len(data),
        'md5': hashlib.md5(data).hexdigest(),
        'url': file_url,
    }
    return result


def main():
    path = os.path.abspath(sys.argv[1])
    result = share_file(path)
    # print result
    print '# file: %s' % result['file']
    print '# size: %s' % result['size']
    print '# md5: %s' % result['md5']
    print result['url']


if __name__ == '__main__':
    main()
