#!/bin/sh
MACLEOD_URL=svn+ssh://arcadia.yandex.ru/arc/trunk/arcadia/junk/abcdenis/pyMacLeod/macleod_maker.py
MACLEOD_REV=2268759
MACLEOD_BASENAME=`basename $MACLEOD_URL`

# http://unix.stackexchange.com/questions/30091/fix-or-alternative-for-mktemp-in-os-x
TEMP=`mktemp -d 2>/dev/null || mktemp -d -t 'psiss-temp-'`

MACLEOD_SCRIPT="$TEMP/$MACLEOD_BASENAME"

svn cat $MACLEOD_URL -r $MACLEOD_REV > $MACLEOD_SCRIPT

# prepare info
INFO=./INFO.txt
test -f $INFO && rm -f $INFO

svn info > $INFO
echo "===" >> $INFO
cat README.txt >> $INFO

python $MACLEOD_SCRIPT --module src/psiss_main.py --no-cc --output psiss --force --info-file $INFO

RELEASE_LOG=release.log

./psiss --version 2>&1 | tee -a $RELEASE_LOG

./kv-share.py psiss | tee -a $RELEASE_LOG

test -f $INFO && rm -f $INFO
rm -rf $TEMP
