# coding=utf-8
import base64
import os
import pickle
import sys
import zlib

import pytz


def read_file(fn, **kw):
    assert os.path.isfile(fn), "file not found: '%s'" % fn

    binmode = kw.get("binmode", 0)
    if binmode:
        open_mode = "rb"
    else:
        open_mode = "r"

    f = open(fn, open_mode)
    if binmode:
        rc = f.read()
        file_size = os.path.getsize(fn)
        assert len(rc) == file_size, "read_file error: read %d bytes, file on disk: %d bytes -- %s" % \
                                     (len(rc), file_size, fn)
    else:
        rc = map(lambda x: x.splitlines()[0], f)
    f.close()

    return rc


def write_file(fn, data, **kw):
    binmode = kw.get("binmode", 0)
    if binmode:
        open_mode = "wb"
    else:
        open_mode = "w"

    f = open(fn, open_mode)
    if binmode:
        f.write(data)
    else:
        f.write("\n".join(data))

    f.close()
    return True

def write_init_file(work_dir, timezone64_oneline, pytz_version):
    module_body_mask = """
#!/usr/bin/env python
# coding=utf-8

#========================
# this is module for patching pytz.open_resource
# for replacing file reading with pure python declared structure
#
# made from pytz <PYTZ_VERSION> data files
#========================

import StringIO
import base64
import pickle
import zlib

import pytz

PYTZ_TIMEZONE_BLOB = \"\"\"
<BLOB>\"\"\"

PYTZ_DICT = None


def open_pure_python_resource(name):
    if name not in PYTZ_DICT:
        return None
    else:
        return StringIO.StringIO(PYTZ_DICT[name])


_PREV_OPEN_RESOURCE = None

def install_internal_pytz_storage():
    global _PREV_OPEN_RESOURCE
    _PREV_OPEN_RESOURCE = pytz.open_resource
    pytz.open_resource = open_pure_python_resource


PYTZ_DICT = pickle.loads(zlib.decompress(base64.decodestring(PYTZ_TIMEZONE_BLOB)))


if __name__ == "__main__":
    print len(PYTZ_DICT)
"""
    module_dir = os.path.join(work_dir, "pytzstorage")
    try:
        os.makedirs(module_dir)
    except:
        pass

    module = module_body_mask.replace("<PYTZ_VERSION>", pytz_version).replace('<BLOB>', timezone64_oneline)
    init_filename = os.path.join(module_dir, '__init__.py')
    write_file(init_filename, module, binmode=True)
    print "written", init_filename


def write_setup_py(work_dir, pytz_version):
    SETUP_PY_MASK = """

#!/usr/bin/env python
# coding=utf-8
from setuptools import setup, find_packages

VERSION = "<VERSION>"

if __name__ == "__main__":
    setup(
        name="pytzstorage",
        version=VERSION,
        install_requires=[
            "pytz==<VERSION>",
        ],
        description="pytz module helper for storing data files inside python source",
        packages=["pytzstorage",],
        author="Denis Barmenkov",
        author_email="abcdenis@yandex-team.ru",
        package_data={},
        package_dir={"pytzstorage": "pytzstorage"},
        zip_safe=False,
    )


"""
    setup_body = SETUP_PY_MASK.replace("<VERSION>", pytz_version)
    setup_filename = os.path.join(work_dir, "setup.py")
    write_file(setup_filename, setup_body, binmode=True)
    print "written", setup_filename


PYTZ_VERSION = '2016.3'

assert pytz.__version__ == PYTZ_VERSION, 'pytz version %r required but %r found' % (PYTZ_VERSION, pytz.__version__)

all_timezones = set(pytz.all_timezones)
common_timezones = set(pytz.common_timezones)

if all_timezones != common_timezones:
    print "all_timezones:", len(all_timezones)
    print "common_timezones:", len(common_timezones)
    common_unique = set(common_timezones) - set(all_timezones)
    if common_unique != set():
        sys.exit('some zones are in common list only: %r' % (common_unique, ))

# create dir
work_dir = os.path.join(os.path.dirname(sys.argv[0]), 'pytz_storage_module')
#if os.path.isdir(work_dir):
#    os.rmdir(work_dir)

try:
    os.makedirs(work_dir)
except:
    pass

# collect files form pytz
filenames = pytz.all_timezones
print "timezones count:", len(filenames)
pytz_root = os.path.dirname(pytz.__file__)
zoneinfo_root = os.path.join(pytz_root, 'zoneinfo')
# print pytz_root

timezone_dict = {}

for key in filenames:
    fullname = os.path.join(zoneinfo_root, key)
    # print "read", key, "from", fullname

    if not os.path.isfile(fullname):
        sys.exit("file not found: %r" % (fullname,))

    blob = read_file(fullname, binmode=True)
    # print "read", len(blob), "bytes from", fullname
    timezone_dict[key] = blob

timezone64_oneline = base64.encodestring(zlib.compress(pickle.dumps(timezone_dict)))
#print len(timezone64)

# sources =

write_init_file(work_dir, timezone64_oneline, PYTZ_VERSION)
write_setup_py(work_dir, PYTZ_VERSION)

# write python file
# write setup.py
