import urllib2
import json
"""
{
    "appliedTime": -1,
    "doneTime": -1,
    "finishedTime": -1,
    "fsmState": "INITIAL",
    "groupIdStr": "-EHZcPVDEeaocwAlkJQnzA",
    "groupLiveState": "pending",
    "issAckTime": -1,
    "lastIssAckTime": 0,
    "lastQueueToIssAckTime": 4452757,
    "lastQueueToStartedTime": 4452757,
    "lastQueueWaitingTime": 4452757,
    "lastStartingTime": 0,
    "planningPolicyName": "all-or-none",
    "putInQueueTime": 1487423636330,
    "startedTime": -1,
    "totalFinishingTime": 0,
    "totalIssAckTime": 0,
    "totalQueueToIssAckTime": 0,
    "totalQueueToStartedTime": 0,
    "totalQueueWaitingTime": 0,
    "totalRestartCount": 0,
    "totalRestartCountByJobFail": 0,
    "totalRestartCountBySystemFail": 0,
    "totalStartingTime": 0
},
"""
# url = "https://job-service-c.n.yandex-team.ru/api/jobs_debug/metrics/groups"
#
# raw = urllib2.urlopen(url).read()
metrics_file = "/Users/abcdenis/tmp/nirvana-18feb/metrics.json"
raw = open(metrics_file).read()

print len(raw), "bytes received"

data = json.loads(raw)
groups = data["jobServiceGroupMetrics"]["metrics"]
print len(groups), "groups received"

groups = [g for g in groups if g is not None]

groups = [g for g in groups if g["groupLiveState"] in ("pending", "running")]
print len(groups), "groups pending or running"

# master-slave
groups = [g for g in groups if g["planningPolicyName"] == "master-slave"]
print len(groups), "master-slave groups"

groups.sort(key=lambda g: g["lastIssAckTime"], reverse=True)

for group, index in zip(groups, range(20)):
    print group["groupIdStr"], "-", group["lastIssAckTime"], "msec"


