# coding=utf-8
from pprint import pprint as pp

import thriftlib
from thriftlib import thrift_to_python

import iss_thrift3.ttypes
from iss_thrift3.ttypes import Portion


def list_branch_configurations(proxy, branch_head):
    response = proxy.getBranchHeads(branch_head)
    return thrift_to_python(response, iss_thrift3.ttypes)


def load_configuration(proxy, conf_name):
    response = proxy.getConfiguration(conf_name, Portion(0, 2147483647))
    return thrift_to_python(response, iss_thrift3.ttypes)


proxy = thriftlib.ThriftServerProxy(url='thrift://iss01e-dev.search.yandex.net:9090', timeout=120)

conf_list = list_branch_configurations(proxy, branch_head='CURRENT')

print "=== list_branch_configurations(proxy, 'CURRENT') ==="
pp(conf_list)
print

conf_name = conf_list['configurations'].pop()
print 'some config:', conf_name
pp(load_configuration(proxy, conf_name))
print
