# coding=utf-8
import re
from setuptools import setup


version = 'development'
with open('src/thriftlite/version.py') as version_file:
    for line in version_file:
        match = re.match(r"^VERSION\s*=\s*\'([^\'\"]+)\'", line)
        if match:
            version = match.group(1)
            break


if __name__ == '__main__':
    setup(
        name='thriftlite',
        version=version,
        packages=['thriftlite', ],
        package_dir={'thriftlite': 'src/thriftlite'},
        install_requires="thrift==0.9.1",
        author='Denis Barmenkov',
        author_email='abcdenis@yandex-team.ru',
        description='Thrift wrapper',
        zip_safe=False,
        url='https://wiki.yandex-team.ru/iss3',
    )
