#!/bin/bash
set -e 

ARCHIVES_DIR=/tmp/archives
TEAMCITY_AGENT_SOURCE_URL=https://simcity.yandex-team.ru/update/buildAgent.zip
UNTAR_TEMP_DIR=/tmp/untar
JDK_DIR=/opt/iss_jdk_8
JDK_SOURCE_URL=https://proxy.sandbox.yandex-team.ru/1825838389
ROBOT_HOME=/home/robot-iss-build-bot
MAVEN_BIN_URL=https://archive.apache.org/dist/maven/maven-3/3.3.9/binaries/apache-maven-3.3.9-bin.tar.gz

export DEBIAN_FRONTEND=noninteractive;

{
	set +x;
	if [ -z "$YAV_OAUTH_TOKEN" ]
	then
		echo "Empty variable YAV_OAUTH_TOKEN";
		exit 1;
	fi
    if [ -z "$ISS_AGENT_VERSION" ]
	then
		echo "Empty variable ISS_AGENT_VERSION";
		exit 1;
	fi
    if [ -z "$ISS_JDK_VERSION" ]
	then
		echo "Empty variable ISS_JDK_VERSION";
		exit 1;
	fi
    if [ -z "$PORTO_VERSION" ]
	then
		echo "Empty variable PORTO_VERSION";
		exit 1;
	fi
    if [ -z "$THRIFT_093_HTTP_URL" ]
	then
		echo "Empty variable THRIFT_093_HTTP_URL";
		exit 1;
	fi
    if [ -z "$RAM_DISK_SIZE" ]
	then
		echo "Empty variable RAM_DISK_SIZE";
		exit 1;
	fi
	set -x;
} 2>/dev/null

useradd -m -s /bin/bash robot-iss-build-bot || true;
groupadd -g 22625 dpt_virtual_robots_iss || true;

#if [[ ! -z "$DNS_CRUTCH" ]]; then
#    # crutch for 
#    # RUNTIMECLOUD-7982 RUNTIMECLOUD-15046
#    echo "Applying dns crutch..."
#    cp /etc/resolv.conf /etc/resolv.conf.bak;
#    cat >/etc/resolv.conf << EOF
#    search search.yandex.net
#    nameserver 2a02:6b8:0:3400::5005
#    options timeout:1 attempts:1
#    EOF

#    apt-get install -y yandex-config-dns64;

#    sudo cp /etc/resolv.conf.bak /etc/resolv.conf;
#fi

if [[ ! -z "$TEAMCITY_AGENT_ALT_URL" ]]; then
    TEAMCITY_AGENT_SOURCE_URL="$TEAMCITY_AGENT_ALT_URL";
fi

if [[ ! -z "$MAVEN_BIN_ALT_URL" ]]; then
    MAVEN_BIN_URL="$MAVEN_BIN_ALT_URL";
fi

apt-get update;

# ========================== Secrets and stuff =================================== #
apt-get install --allow-unauthenticated -y python-pip yandex-passport-vault-client;
yes w | pip install --upgrade "pip < 21.0"
yes w | pip install --upgrade setuptools; 
yes w | pip install paramiko requests; # needs for yav python client;

mkdir -p $ROBOT_HOME/.ssh

cat << EOF > $ROBOT_HOME/secrets.py
#!/usr/bin/env python2"
# -*- coding: utf-8 -*-

from vault_client.instances import Production as VaultClient
import argparse
import os

ROBOT_HOME = "/home/robot-iss-build-bot"


def main():
        parser = argparse.ArgumentParser(description='Getting yav secrets for robot')
        parser.add_argument("token", help="OAuth token for vault, details here https://vault-api.passport.yandex.net/docs/#oauth")
        parser.add_argument("--secret-uuid", dest="secret_uuid", help="Look for it in yav.yandex-team.ru", default="sec-01d4hze11e1810mtashg6ghz8f")
        args = parser.parse_args()

        ssh_dir = os.path.join(ROBOT_HOME, ".ssh")

        client = VaultClient(
                authorization='OAuth {}'.format(args.token),
                decode_files=True,
        )

        head_version = client.get_version(args.secret_uuid)
        kr = head_version["value"]["keyring"]
        with open(os.path.join(ROBOT_HOME, "keyring.tar.gz"), "ab") as f:
                f.write(b'%s' % kr)
        
        with open(os.path.join(ROBOT_HOME, ".pypirc"), "w") as f:
                f.write(head_version["value"][".pypirc"])

        for key in ["id_rsa_robot", "id_rsa_robot.pub"]:
                value = head_version["value"][key]
                with open(os.path.join(ssh_dir, key), "w") as f:
                        f.write(value)


if __name__ == "__main__":
        main()
EOF

python $ROBOT_HOME/secrets.py $YAV_OAUTH_TOKEN 

tar xfz $ROBOT_HOME/keyring.tar.gz --directory $ROBOT_HOME;

cat << EOF > $ROBOT_HOME/.ssh/config
ForwardAgent yes
PubkeyAuthentication yes
HashKnownHosts no
StrictHostKeyChecking no

Host svn.yandex.ru localhost arcadia.yandex.ru git.yandex.ru bb.yandex-team.ru hg.yandex-team.ru github.yandex-team.ru
        IdentityFile $ROBOT_HOME/.ssh/id_rsa_robot
        User robot-iss-build-bot

Host localhost iss-ci-vm-*
     IdentityFile $ROBOT_HOME/.ssh/id_rsa_robot
     User robot-iss-build-bot
EOF


chown -R robot-iss-build-bot:robot-iss-build-bot $ROBOT_HOME/.ssh;
chmod -R 0444 $ROBOT_HOME/.ssh;
chmod -R 0400 $ROBOT_HOME/.ssh/id_rsa_robot $ROBOT_HOME/.ssh/id_rsa_robot.pub;

# ========================== End of secrets and stuff =================================== #

#get version from env
apt-get install --allow-unauthenticated -y --allow-downgrades yandex-porto=$PORTO_VERSION unzip man;
usermod -a -G porto robot-iss-build-bot;

#get version from env
apt-get install -y --allow-unauthenticated --allow-downgrades yandex-diskmanager;
# https://wiki.yandex-team.ru/runtime-cloud/disk-manager/
apt-get install  --allow-remove-essential --force-yes -y e2fslibs=1.44.1-1ubuntu1.3-yandex0;
apt-get install  --allow-remove-essential --force-yes -y e2fsprogs=1.44.1-1ubuntu1.3-yandex0;
sudo usermod -a -G diskmanager robot-iss-build-bot;

cat << EOF > /etc/diskmanager.conf
[SERVER]
include_dev=loop
EOF

apt-get install -y --allow-unauthenticated --allow-downgrades git protobuf-compiler maven3;

# download fresh (which can handle nested scp params) ant version
wget https://downloads.apache.org//ant/binaries/apache-ant-1.10.9-bin.tar.gz;
tar -xf apache-ant-1.10.9-bin.tar.gz -C /usr/local;
ln -s /usr/local/apache-ant-1.10.9/ /usr/local/ant;
echo 'export ANT_HOME=/usr/local/ant' >> /etc/profile.d/ant.sh;
echo 'export PATH=${ANT_HOME}/bin:${PATH}' >> /etc/profile.d/ant.sh;

mkdir -p $ARCHIVES_DIR;
mkdir -p $JDK_DIR;

# =========================== Teamcity agent setup ======================================= #
mkdir -p /opt/teamcity_agent;
wget $TEAMCITY_AGENT_SOURCE_URL -O $ARCHIVES_DIR/buildAgent.zip;
unzip $ARCHIVES_DIR/buildAgent.zip -d /opt/teamcity_agent;

cat << EOF > /opt/teamcity_agent/conf/buildAgent.properties
## TeamCity build agent configuration file

######################################
#   Required Agent Properties        #
######################################

## The address of the TeamCity server. The same as is used to open TeamCity web interface in the browser.
## Example:  serverUrl=https://buildserver.mydomain.com:8111
serverUrl=https://simcity.yandex-team.ru

## The unique name of the agent used to identify this agent on the TeamCity server
## Use blank name to let server generate it.
## By default, this name would be created from the build agent's host name
name=...

## Container directory to create default checkout directories for the build configurations.
## TeamCity agent assumes ownership of the directory and will delete unknown directories inside.
workDir=../work

## Container directory for the temporary directories.
## TeamCity agent assumes ownership of the directory. The directory may be cleaned between the builds.
tempDir=../temp

## Container directory for agent state files and caches.
## TeamCity agent assumes ownership of the directory and can delete content inside.
systemDir=../system

######################################
#   Optional Agent Properties        #
######################################

######################################
#   Default Build Properties         #
######################################
# Build Script Properties

#system.exampleProperty=example Value

# Environment Variables

env.JDK_18=$JDK_DIR
EOF

chown -R robot-iss-build-bot:dpt_virtual_robots_iss /opt/teamcity_agent;

cat << EOF > /etc/systemd/system/teamcity.service
[Unit]
Description=TeamCity Agent
After=network.target

[Install]
WantedBy=multi-user.target

[Service]
ExecStart=/opt/teamcity_agent/bin/agent.sh start
Type=forking
RemainAfterExit=yes
User=robot-iss-build-bot
Group=robot-iss-build-bot
SyslogIdentifier=teamcity_agent
PrivateTmp=no
PIDFile=/opt/teamcity_agent/logs/buildAgent.pid
ExecStop=/opt/teamcity_agent/bin/agent.sh stop
RestartSec=5
Restart=on-failure
LimitNOFILE=1500000
LimitNPROC=1500000
EOF


# ========================== End of Teamcity setup =================================== #


# ========================== JDK setup section     ==================================== #
#конкретная версия jdk может передаваться через env
mkdir -p $JDK_DIR;
mkdir -p $UNTAR_TEMP_DIR/jdk;
wget $JDK_SOURCE_URL -O $ARCHIVES_DIR/jdk.tar.gz;

tar xfz $ARCHIVES_DIR/jdk.tar.gz --directory $UNTAR_TEMP_DIR/jdk; cp -R $UNTAR_TEMP_DIR/jdk/*/* $JDK_DIR;

#hash=$(md5sum /opt/iss_jdk_8/jdk.tar.gz | awk '{ print $1 }')
#чек хэша

sudo update-alternatives --install /usr/bin/appletviewer appletviewer $JDK_DIR/bin/appletviewer 1
sudo update-alternatives --install /usr/bin/extcheck extcheck $JDK_DIR/bin/extcheck 1
sudo update-alternatives --install /usr/bin/idlj idlj $JDK_DIR/bin/idlj 1
sudo update-alternatives --install /usr/bin/jar jar $JDK_DIR/bin/jar 1
sudo update-alternatives --install /usr/bin/jarsigner jarsigner $JDK_DIR/bin/jarsigner 1
sudo update-alternatives --install /usr/bin/java java $JDK_DIR/bin/java 1
sudo update-alternatives --install /usr/bin/javac javac $JDK_DIR/bin/javac 1
sudo update-alternatives --install /usr/bin/javadoc javadoc $JDK_DIR/bin/javadoc 1
sudo update-alternatives --install /usr/bin/javah javah $JDK_DIR/bin/javah 1
sudo update-alternatives --install /usr/bin/javap javap $JDK_DIR/bin/javap 1
sudo update-alternatives --install /usr/bin/javaws javaws $JDK_DIR/bin/javaws 1
sudo update-alternatives --install /usr/bin/jconsole jconsole $JDK_DIR/bin/jconsole 1
sudo update-alternatives --install /usr/bin/jdb jdb $JDK_DIR/bin/jdb 1
sudo update-alternatives --install /usr/bin/jhat jhat $JDK_DIR/bin/jhat 1
sudo update-alternatives --install /usr/bin/jinfo jinfo $JDK_DIR/bin/jinfo 1
sudo update-alternatives --install /usr/bin/jmap jmap $JDK_DIR/bin/jmap 1
sudo update-alternatives --install /usr/bin/jps jps $JDK_DIR/bin/jps 1

echo "JAVA_HOME=$JDK_DIR" >> /etc/environment;

# https://wiki.yandex-team.ru/security/ssl/sslclientfix/#vjava

wget https://crls.yandex.net/YandexInternalRootCA.crt -O /tmp/YandexInternalRootCA.crt;
$JDK_DIR/bin/keytool -importcert -noprompt -storepass "changeit" -file /tmp/YandexInternalRootCA.crt -keystore $JDK_DIR/jre/lib/security/cacerts  -alias "Yandex";

# original link for download in case resource is gone 
# wget https://archive.apache.org/dist/maven/maven-3/3.3.9/binaries/apache-maven-3.3.9-bin.tar.gz -O /tmp/apache-maven-3.3.9-bin.tar.gz;
wget $MAVEN_BIN_URL -O /tmp/apache-maven-3.3.9-bin.tar.gz;
tar xfvz /tmp/apache-maven-3.3.9-bin.tar.gz --directory /opt/;
# md5 516923b3955b6035ba6b0a5b031fbd8b


mkdir -p $ROBOT_HOME/.m2;
#forcing https for maven mostly for thrift build
cat << EOF > $ROBOT_HOME/.m2/settings.xml
<settings>
   <mirrors>
     <mirror>
      <id>force-https-mirror</id>
      <name>Other Mirror Repository</name>
      <url>http://artifactory.yandex.net/artifactory/public</url>
      <mirrorOf>central</mirrorOf>
    </mirror>
  </mirrors>
</settings>
EOF

mkdir -p ~/.m2;
cat << EOF > ~/.m2/settings.xml
<settings>
   <mirrors>
     <mirror>
      <id>force-https-mirror</id>
      <name>Other Mirror Repository</name>
      <url>http://artifactory.yandex.net/artifactory/public</url>
      <mirrorOf>central</mirrorOf>
    </mirror>
  </mirrors>
</settings>
EOF

# ====================================== Building trift ========================================= #
# https://thrift.apache.org/docs/BuildingFromSource

apt-get install --allow-unauthenticated -y make g++ autoconf automake libtool libssl-dev bison;
THRIFT_DIR=/tmp/thrift;

mkdir -p $THRIFT_DIR;
# original link for download in case resource is gone
# wget http://archive.apache.org/dist/thrift/0.9.3/thrift-0.9.3.tar.gz -O /tmp/thrift/thrift-0.9.3.tar.gz;  
wget $THRIFT_093_HTTP_URL -O $THRIFT_DIR/thrift-0.9.3.tar.gz;
tar xfvz $THRIFT_DIR/thrift-0.9.3.tar.gz --directory $THRIFT_DIR;
cd $THRIFT_DIR/thrift-0.9.3;
./configure JAVAC=/usr/bin/javac --with-java;

# From the building env we have access only to local yandex artifactory so force tasks to use it instead of default maven central  
sed 's/^mvn\.repo\=[^ ]*/mvn\.repo\=http:\/\/artifactory\.yandex\.net\/artifactory\/public/' ./lib/java/build.properties -i
sed 's/id="central" url=[^ ]*/id="central" url="http:\/\/artifactory\.yandex\.net\/artifactory\/public"\/>/' ./lib/java/build.xml -i;
sed 's/<artifact:dependencies filesetId="build-dependency-jars" pomRefId="pom"\/>/<artifact:dependencies filesetId="build-dependency-jars" settingsFile="\/\.m2\/settings.xml" pomRefId="pom"\/>/' ./lib/java/build.xml -i;
sed 's/<artifact:dependencies filesetId="test-dependency-jars" useScope="runtime">/<artifact:dependencies filesetId="test-dependency-jars" settingsFile="\/\.m2\/settings.xml" useScope="runtime">/' ./lib/java/build.xml -i;
cat ./lib/java/build.properties;
export _JAVA_OPTIONS="-Dmaven.repo.remote=http://artifactory.yandex.net/artifactory/public -Djava.net.preferIPv6Addresses=true"
make;
cat ./lib/java/build.properties;
make install;

# ====================================== End of building trift section  ===================================== #

# Directory for test temporary files
mkdir -p /place/it;
chown -R robot-iss-build-bot:robot-iss-build-bot  /place/it;

chown -R robot-iss-build-bot:robot-iss-build-bot  $ROBOT_HOME/.m2;

# vms are slow so we move all we can to ram
echo "tmpfs /opt/teamcity_agent/temp  tmpfs   rw,nodev,nosuid,size=4G          0  0" >> /etc/fstab;
echo "tmpfs /opt/teamcity_agent/work  tmpfs   rw,nodev,nosuid,size=6G          0  0" >> /etc/fstab;

apt-get install --allow-unauthenticated -y virtualenv python-portopy yandex-linux-image-stable libxml-xpath-perl;
apt-get install --allow-unauthenticated -y yandex-search-user-uploadbase telnet;

# ===================================================== Setup standalone stock iss-agent on host ==================================================== #

# We need a working iss-agent for cacher+agent tests. More info here https://wiki.yandex-team.ru/iss3/testing/runningtests/#zachemnuzhenstandalone-agent
apt-get install --allow-unauthenticated -y iss-jdk=$ISS_JDK_VERSION iss-agent=$ISS_AGENT_VERSION;

mkdir /iss3;
chown loadbase:loadbase /iss3;
touch /db/iss3/_initial_start_marker;
chown loadbase:loadbase /db/iss3/_initial_start_marker;

cat << EOF > /db/iss3/application.conf
{
    "agent": {
        "aliveMarkerAllowedAge": "600s", 
        "check_persist_volume_presence_in_hostconfig": true, 
        "defaultStorage": "/place", 
        "dynamic_resources": {
            "cleanup_policy": "pending", 
            "max_depth_before_next_sync": 8, 
            "reset_parent_driver_status": true, 
            "retries": 10
        }, 
        "fetcher": {
            "fastTaskPoolSize": 5, 
            "filesTimeout": "5m", 
            "slowTaskPoolSize": 5,
            "containerized": {
               "meta_name": "th_meta"
            }
        }, 
        "gc": {
            "delayBeforeSpecialGcCleanup": "1s", 
            "fullSyncsBeforeSpecialGcCleanup": 1, 
            "processGCLogWarnDuration": "10m", 
            "volumeGCDelay": "5m", 
            "volumeGCEnabled": true
        }, 
        "hook_behaviour": {
            "rerunStatusHooksOnAgentRestart": true
        }, 
        "hostConfiguration": {
            "primaryProvider": {
                "connection": {
                    "connectionTimeout": "30s", 
                    "retryCount": 2, 
                    "retryTimeout": "1s"
                }, 
                "host": "iss3.yandex-team.ru", 
                "mergePolicy": "withRespectToDeltas", 
                "port": 9090, 
                "type": "thrift"
            }, 
            "providersNumber": 1, 
            "ypProvider": {
                "allowApply": false, 
                "enabled": false, 
                "heartbeatInterval": "1m", 
                "host": "localhost", 
                "notify": {
                    "port": 25540
                }, 
                "port": 8080
            }
        }, 
        "install_hook_scheduler": {
            "active_goal_factor": 10, 
            "age_threshold": "5m", 
            "aging_additional_factor": 0.2, 
            "default_weight_for_unknown_goal": 0, 
            "enable": true, 
            "hook_type": "iss_hook_install", 
            "how_many_prepared_instances_for_additional_weights": 1, 
            "id": "install_hook_scheduler", 
            "max_concurrency": 4, 
            "prepared_goal_factor": 5, 
            "queue_capacity": 20, 
            "slot_has_another_active_instance_factor": -0.1, 
            "slot_has_no_active_instances_factor": 0.1, 
            "use_aging": false
        },
	"walle_status_check": {
		"type": "dummy"
	},
    "ipAwaiting": {
        "executor": {
            "poolSize": 1, 
            "queueSize": 4
        }, 
        "http": {
            "bodyTailSize": "128b", 
            "connectTimeout": "2s", 
            "readTimeout": "2s", 
            "urlTemplate": "http://127.0.0.1:9876/ip_address_ready?ip=%s"
        }, 
        "strategy": "http", 
        "timeLimits": {
            "maxExecutionTime": "5s", 
            "minRestartPeriod": "1m"
        }
    }, 
    "jmx": {
        "jolokia": {
            "policyLocation": "classpath:/jolokia.policy"
        }, 
        "mp": {
           "port": 25537
        }
    }, 
    "jsonDynamicPropertyFiles": [
            "platform-properties.json"
    ], 
    "loggingSettingsPath": "./", 
        "porto": {
            "async": {
                "dispatcher": {
                    "cache": {
                        "layer": {
                            "write": "15m"
                        }, 
                        "volume": {
                            "write": "15m"
                        }
                    }
                }, 
                "poolSize": 10, 
                "timeouts": {
                    "createVolume": {
                        "requestTimeout": "10m"
                    }, 
                    "default": {
                        "connectTimeout": "20s", 
                        "requestTimeout": "20s"
                    }, 
                    "importLayer": {
                        "requestTimeout": "10m"
                    }, 
                    "linkVolume": {
                        "requestTimeout": "10m"
                    }, 
                    "removeLayer": {
                        "requestTimeout": "10m"
                    }, 
                    "unlinkVolume": {
                        "requestTimeout": "10m"
                    }
                }
            }, 
        "defaultUlimit": "nofile: 102400 204800; memlock: 41943040000 41943040000", 
        "metaProcessContainer": "ISS-AGENT", 
        "propertyListProvider": {
                "restrictedList": {
                    "data": [
                        "max_rss", 
                        "time", 
                        "cpu_usage"
                    ], 
                    "properties": []
                }, 
                "type": "restrict"
            }, 
            "socketPath": "/run/portod.socket", 
            "socketTimeOut": 8000, 
            "use_target_property": true, 
            "volume_allowed_properties": [
                "read_only"
            ], 
            "waitTimeout": "1s", 
            "workers": 2
        }, 
        "preemptionStrategy": "preempt-implicitly-removed", 
        "printPostMortem": true, 
        "reopenlogs": {
            "akkaTimeout": "10m", 
            "retries": 5
        }, 
        "root": ".", 
        "rootOnStorage": "db/iss3", 
        "shardtracker": {
            "cacheLifeTime": "5m", 
            "host": "shardtracker.search.yandex.net", 
            "port": 9100, 
            "timeout": "3s"
        }, 
        "spaceToLeaveOnDisk": "10g", 
        "state": {
            "migrator": "_", 
            "path_to_initial_startup_marker": "/db/iss3/_initial_start_marker", 
            "statePreallocatedSizeMb": 100, 
            "stateRollover": "legacy", 
            "stateStoragePath": "/iss3", 
        }, 
        "storageMountPoints": [
            "/place"
        ], 
        "sync": {
            "autoSyncPeriod": "60s", 
            "autoUpdatePeriod": "60s", 
            "minResyncPeriod": "500ms"
        }, 
        "tmp": "/iss3/tmp", 
        "webapp": {
            "pool_size": 10, 
            "port": 25536, 
            "queue_size": 20, 
            "request_timeout_ms": 120000
        }
    }, 
    "akka": {
        "actor": {
            "default-dispatcher": {
                "executor": "fork-join-executor", 
                "fork-join-executor": {
                    "parallelism-factor": 1, 
                    "parallelism-max": 3, 
                    "parallelism-min": 1
                }, 
                "type": "Dispatcher"
            }, 
            "mailbox": {
                "requirements": {
                    "ru.yandex.iss.utils.EvictingUnboundedMessageQueueSemantics": "evicting-dispatcher-mailbox"
                }
            }
        }, 
        "logger-startup-timeout": "25s", 
        "loggers": [
            "akka.event.slf4j.Slf4jLogger"
        ], 
        "loglevel": "ERROR"
    }, 
    "evicting-dispatcher": {
        "mailbox-requirement": "ru.yandex.iss.utils.EvictingUnboundedMessageQueueSemantics"
    }, 
    "evicting-dispatcher-mailbox": {
        "mailbox-capacity": 1000, 
        "mailbox-type": "ru.yandex.iss.utils.EvictingMailbox"
    }, 
    "pusher": {
        "port": 9999
    }, 
    "remote": {
        "host": "::", 
        "port": 0
    }, 
    "servlet-dispatcher": {
        "executor": "thread-pool-executor", 
        "thread-pool-executor": {
            "core-pool-size-factor": 1, 
            "core-pool-size-max": 2, 
            "core-pool-size-min": 0
        }, 
        "type": "Dispatcher"
    }
}
EOF

chown loadbase:loadbase /db/iss3/application.conf;

cat << EOF > /db/iss3/porto.options
env=MALLOC_ARENA_MAX=2;PATH=/usr/local/sbin:/usr/local/bin:/usr/sbin:/usr/bin:/sbin:/bin:
isolate=false
cpu_guarantee=2c
cpu_limit=2c
memory_limit=1100m
anon_limit=900m
memory_guarantee=1100m
porto_namespace=
enable_porto=true
cwd=/place/db/iss3
#-- start managed zone --
#-- end managed zone --
EOF


chown loadbase:loadbase /db/iss3/porto.options;

# ===================================================== End of setup standalone stock iss-agent on host =========================================== #

# ===================================================== Git setup ================================================================================= #
cat << EOF > $ROBOT_HOME/.gitconfig
[user]
        email = robot-iss-build-bot@yandex-team.ru
        name = robot-iss-build-bot
EOF

chown robot-iss-build-bot:robot-iss-build-bot $ROBOT_HOME/.gitconfig;


# ===================================================== End of Git setup section ==================================================================== #

# ============================================================ Ramfs setup and mounts =============================================================== #
cat << EOF > /etc/systemd/system/tmp_ramdisk.service
[Unit]
Description=Ramdisk
After=syslog.target
Requires=local-fs.target
After=local-fs.target

[Service]
Type=oneshot
RemainAfterExit=yes
ExecStart=/usr/share/tmp_ramfs.sh make
ExecStop=/usr/share/tmp_ramfs.sh remove

[Install]
WantedBy=local-fs.target
EOF

mkdir -p /etc/systemd/system/local-fs.target.wants;
ln -s /etc/systemd/system/tmp_ramdisk.service /etc/systemd/system/local-fs.target.wants/tmp_ramdisk.service;

cat << EOF > /usr/share/tmp_ramfs.sh
#!/bin/bash
if [ -b '/dev/vdc1' ]; then
        echo "Looks like ssd scheme...";
        mkdir -p /place/it;
        mkdir -p /extra_disk_1/it;
        mount --bind /extra_disk_1/it /place/it;
        chown -R robot-iss-build-bot:robot-iss-build-bot /place/it;
else
        echo "No ssd";
        modprobe brd rd_nr=2 rd_size=13285760;
        mkfs.ext4 -F -m 0 /dev/ram0;
        mkfs.ext4 -F -m 0 /dev/ram1;
        mount /dev/ram0 /tmp;
        mkdir -p /place/tmp_porto_place;
        mount /dev/ram1 /place/tmp_porto_place;
        chmod 0777 /tmp;

        mkdir /place/tmp_porto_place/porto_{volumes,storage,layers};
        mkdir /place/tmp_porto_place/porto;

        mount --bind /place/tmp_porto_place/porto_place/porto_volumes /place/porto_volumes;
        mount --bind /place/tmp_porto_place/porto_storage /place/porto_storage;
        mount --bind /place/tmp_porto_place/porto /place/porto;
        mount --bind /place/tmp_porto_place/porto_layers /place/porto_layers;
fi
mkdir /tmp/pytest;
mkdir -p /place/vartmp/teamcity;
mount --bind /tmp/pytest /place/vartmp/teamcity;
chown -R robot-iss-build-bot:robot-iss-build-bot /place/vartmp/teamcity;
EOF

chmod +x /usr/share/tmp_ramfs.sh;

cat << EOF > /usr/share/loop_device.sh
#!/bin/bash
echo "Setup disk...";
fallocate -l 4G /tmp/testdisk
losetup --find --show /tmp/testdisk;
sleep 10;
present=\$(dmctl | grep /dev/loop | awk '{ print \$2 }');
echo "Loop device presented: \$present"
while [ -z "\$preset" ]; do
        sleep 10;
        present=\$(dmctl | grep /dev/loop | awk '{ print \$2 }');
        echo "Loop device presented: \$present"
        if [ -n "\$present" ]; then
                echo "Loop device vailable \$present."
                break;
        fi
done
dmctl disk-format "\$present";
EOF

chmod +x  /usr/share/loop_device.sh;

cat << EOF > /etc/systemd/system/loop_device.service
[Unit]
Description=Test loop device
Requires=tmp_ramdisk.service yandex-diskmanager.service
After=tmp_ramdisk.service yandex-diskmanager.service

[Service]
Type=oneshot
RemainAfterExit=no
ExecStart=/usr/share/loop_device.sh
EOF

ln -s /etc/systemd/system/loop_device.service /etc/systemd/system/local-fs.target.wants/loop_device.service;

# ============================================================ End of ramfs setup and mounts ============================================================= #

# ============================================================      Porto config setup     =============================================================== #
mkdir -p /etc/portod.conf.d;

# Pod agent is broken without core_command so enable it
cat << EOF > /etc/portod.conf.d/portod.conf
core {
    enable: true 
    default_pattern: "/coredumps/%e.%p.%s"
    space_limit_mb: 102400
    slot_space_limit_mb: 10240
}
EOF
# ============================================================   End of porto config setup  ============================================================== #

# ============================================================        network  setup       =============================================================== #
cat << EOF > /etc/systemd/network/dummy.netdev
[NetDev]
Name=test_vlan
Kind=dummy
EOF

cat << EOF > /etc/systemd/network/dummy.network
[Match]
Name=test_vlan

[Network]
Address=6b8:6b8:0:408:1077:d47f:d37f:0/64
EOF
# ============================================================   End ofnetwork  setup setup  ============================================================== #

cat << EOF > /etc/server_info.json
{
        "walle_dc": "sas",
        "walle_location": "sas"
}
EOF
