import logging
from multiprocessing import Process

import os
from iss.common.fakes.app import app

__author__ = 'zayac@yandex-team.ru'


class FakeWebService(object):

    def __init__(self, port, log_dir, host='::'):
        self.port = port
        self.process = None
        self.log_path = os.path.join(log_dir, 'web_service.log')
        self.host = host

    def start(self):
        def _start():
            formatter = logging.Formatter('%(created)s %(levelname)s %(funcName)s %(message)s')
            fh = logging.FileHandler(self.log_path)
            fh.setFormatter(formatter)
            app.logger.setLevel(logging.INFO)
            app.logger.addHandler(fh)
            app.run(host=self.host, port=self.port, threaded=True)

        self.process = Process(target=_start)

        self.process.start()

    def stop(self):
        self.process.terminate()
        self.process.join()
