import shelve
import time

import os
from flask import request, abort, Flask
import flask_shelve as shelve
from werkzeug.routing import FloatConverter as BaseFloatConverter
from werkzeug.exceptions import HTTPException
from six import PY2

import string
import random

#from iss.resources import HttpResources


class FloatConverter(BaseFloatConverter):
    regex = r'-?\d+(\.\d+)?'


def _encode(string):
    return string.encode("utf-8") if PY2 else string


def create_app(storage_path):
    app = Flask(__name__)
    app.url_map.converters['float'] = FloatConverter

    file_id = ''.join(random.choice(string.ascii_letters) for _ in range(10))
    app.config['SHELVE_FILENAME'] = os.path.join(storage_path, "shelve-%s.db" % file_id)
    shelve.init_app(app)

    @app.route('/get/<float:sleep>/<int:code>/<resource_name>')
    def get_resource(sleep, code, resource_name):
        app.logger.info('request /%s/%s/%s' % (sleep, code, resource_name))

        if code != 200:
            abort(code)
        time.sleep(sleep)

        db = shelve.get_shelve('c')
        resource_content = db.get(_encode(resource_name), None)
        if resource_content is not None:
            return resource_content

        try:
        #           return HttpResources.get_content(resource_name)
            return ""
        except BaseException:
            app.logger.exception('getting resource %s content failed' % resource_name)
            abort(500)

    @app.route('/put/<resource_name>', methods=['POST'])
    def put_resource(resource_name):
        app.logger.info('registering %s' % resource_name)

        try:
            encoded_resource_name = _encode(resource_name)

            db = shelve.get_shelve('c')
            if encoded_resource_name in db:
                app.logger.exception('resource %s already registered' % resource_name)
                abort(409)

            db[encoded_resource_name] = request.get_data()
        except HTTPException:
            raise
        except BaseException:
            app.logger.exception('resource %s registration failed' % resource_name)
            abort(500)
        return ""

    @app.route('/del/<resource_name>', methods=['POST'])
    def remove_resource(resource_name):
        app.logger.info('removing %s' % resource_name)

        try:
            encoded_resource_name = _encode(resource_name)

            db = shelve.get_shelve('c')
            del db[encoded_resource_name]
        except BaseException:
            app.logger.exception('resource %s removal failed' % resource_name)
            abort(500)
        return ""

    return app
