from iss.common.support.wait import negate_assertion
from iss.common.feedback_state import FeedbackState


def instance_not_activated_assertion(instance_id):
    return negate_assertion(instance_state_assertion(instance_id, FeedbackState.ACTIVE))


def in_properties_assertion(instance_id, property_value):
    def assertion(feedback):
        assert feedback.instanceId == instance_id and property_value in feedback.properties.values()

    return assertion


def instance_state_assertion(instance_id, state):
    def assertion(feedback):
        assert feedback.instanceId == instance_id and feedback.state == state

    return assertion


def instance_not_in_state_assertion(instance_id, state):
    return negate_assertion(instance_state_assertion(instance_id, state))


MAX_RSS_COUNTER = 'metrics/0/counters/counters/max_rss'
CPU_USAGE_COUNTER = 'metrics/0/counters/counters/cpu_usage'
TIME_COUNTER = 'metrics/0/counters/counters/time'


def assert_all_counters_present_in_each(properties):
    for prop in properties:
        assert int(prop[MAX_RSS_COUNTER]) > 0
        assert int(prop[CPU_USAGE_COUNTER]) > 0
        assert int(prop[TIME_COUNTER]) >= 0
