from base64 import b64encode
from six.moves.urllib.parse import quote

import re

from .issagent import HookNames

__author__ = 'sashakruglov@yandex-team.ru'

BASE64_ENCODE = 'base64'


def make_porto_container_regex(agent, port, name=HookNames.META, service_container=False):
    container_prefix = agent.porto_container_prefix
    port = str(port)

    if service_container:
        # hooks containers
        if name == HookNames.SERVICE:
            return re.compile(r'%s--%s' % (container_prefix, port))

        if name == HookNames.META:
            return re.compile(r'%s--%s/%s_\w+' % (container_prefix, port, port))

        return re.compile(r'%s--%s/%s_\w+/%s' % (container_prefix, port, port, name))

    # hooks containers
    if name == HookNames.SERVICE:
        raise Exception("Not supported for service_container=False")

    if name == HookNames.META:
        return re.compile(r'%s--%s\w+' % (container_prefix, port))

    return re.compile(r'%s--%s\w+/%s' % (container_prefix, port, name))


def remove_state_files(agent):
    state_file_paths = agent.get_file_path('state3*')
    assert state_file_paths, 'Agent did not create state3 and state3.backup files'

    for path in state_file_paths:
        # file could be renamed by this time
        agent.run('rm %s' % path, warn=True)


def encode_to_data_url_scheme(data, encoding):
    if encoding == BASE64_ENCODE:
        return 'data:;base64,%s' % b64encode(data)
    else:
        return 'data:,%s' % quote(data, '')


def instance_hook_porto_container(agent, feedback, slot, state):
    container = [fb for fb in feedback if slot in fb.instanceId.slot and fb.state == state][-1].properties[
        'metrics/0/container']
    containers = agent.run('portoctl list', warn=True).split(' ')
    return max([s for s in containers if container in s], key=len).split('\n')[-1]


def instance_hook_output(agent, feedback, slot, state):
    hook_container = instance_hook_porto_container(
        agent, feedback, slot, state)
    instance_stdout = agent.run(
        'portoctl get {} stdout'.format(hook_container))
    instance_stderr = agent.run(
        'portoctl get {} stderr'.format(hook_container))
    return instance_stdout, instance_stderr
