from base64 import b64encode


def make_data_url(to_encode):
    return "data:;base64,{encoded}".format(encoded=b64encode(to_encode))


def make_non_existent_url(custom_path='does_not_exist'):
    return "http://invalid.tld/%s" % custom_path


# Generated by iss-acceptance-tests/test_scipts/long_paths_maker.py
MANY_FILES_ARCHIVE = "many_files.tar.gz"
# Generated by iss-acceptance-tests/scripts/make_venv_bundle.sh
VENV_ARCHIVE = "iss_venv.tar.bz"

# Sandbox resource ids - https://sandbox.yandex-team.ru/resource/<id>
RESOURCE_IDS = {
    MANY_FILES_ARCHIVE: 292930972,
    VENV_ARCHIVE: 292970375
}


def make_sandbox_url(resource_name):
    return "https://proxy.sandbox.yandex-team.ru/%s" % RESOURCE_IDS[resource_name]


SANDBOX_DOWNLOAD_TIMEOUT_SECONDS = 45
