from collections import OrderedDict
from io import StringIO

__author__ = 'sashakruglov@yandex-team.ru'


class VMOptionsParser(object):

    def __init__(self, options=None):
        self._options = OrderedDict()

        if options:
            self.parse_options_list(options)

    def parse_options_list(self, options_list):
        for line in options_list:
            line = line.strip()

            if not line or line.startswith("#"):
                continue

            parts = line.split('=', 1)
            key = parts[0]
            value = len(parts) > 1 and parts[1] or ''
            self._options[key] = value

    def update_config_options(self, options_dict):
        for (key, value) in options_dict.items():
            self._options['-D' + key] = value

    def update_options_list(self, options_list):
        self.parse_options_list(options_list)

    def write_options(self):
        """Returns vmoptions as file-like object"""
        output = []
        for key, value in self._options.items():
            if value:
                value = '=%s' % value
            output.append('%s%s' % (key, value))

        return StringIO(u'\n'.join(output))
