#define _GNU_SOURCE
#define _FILE_OFFSET_BITS 64

#include <stdlib.h>
#include <err.h>
#include <sys/mount.h>
#include <sys/statvfs.h>

int main(int argc, char **argv)
{
	unsigned long flags;
	struct statvfs st;
	char *path;

	if (argc != 2)
		errx(1, "usage: %s <path>", argv[0]);

	path = argv[1];
	if (statvfs(path, &st))
		err(2, "statvfs");

	flags = MS_REMOUNT;
	if (st.f_flag & ST_NOATIME)
		flags |= MS_NOATIME;
	if (st.f_flag & ST_NODIRATIME)
		flags |= MS_NODIRATIME;
	if (st.f_flag & ST_NODEV)
		flags |= MS_NODEV;
	if (st.f_flag & ST_NOEXEC)
		flags |= MS_NOEXEC;
	if (st.f_flag & ST_NOSUID)
		flags |= MS_NOSUID;
	if (st.f_flag & ST_RDONLY)
		flags |= MS_RDONLY;
	if (st.f_flag & ST_RELATIME)
		flags |= MS_RELATIME;
	if (st.f_flag & ST_SYNCHRONOUS)
		flags |= MS_SYNCHRONOUS;

	if (mount(NULL, path, NULL, flags, "nolazytime"))
		err(2, "mount");

	return 0;
}
