#!/usr/bin/env python

import threading
import argparse
import socket
import signal

done = threading.Event()

class DummyThread(threading.Thread):
    def run(self):
        done.wait()

parser = argparse.ArgumentParser()
parser.add_argument('--threads', type=int, default=100, help="default: %(default)s")
parser.add_argument('--sockets', type=int, default=1000, help="default: %(default)s")

args = parser.parse_args()

sockets = []
for i in range(args.sockets):
    sk = socket.socket(socket.AF_INET)
    sockets.append(sk)

try:
    threads = []
    for i in range(args.threads):
        th = DummyThread()
        th.start()
        threads.append(th)
    signal.pause()
finally:
    done.set()
    for th in threads:
        th.join()
