// https://st.yandex-team.ru/KERNEL-430

#include <linux/kallsyms.h>
#include <linux/module.h>
#include <linux/cgroup.h>

MODULE_AUTHOR("Dmitry Yakunin <zeil@yandex-team.ru>");
MODULE_DESCRIPTION("Clean cgroups leaked on mode switch");
MODULE_LICENSE("GPL");

static inline void *lookup_name(const char *name)
{
	return (void *)kallsyms_lookup_name(name);
}

static inline bool cgroup_on_dfl(const struct cgroup *cgrp)
{
	return cgrp->root == &cgrp_dfl_root;
}

static inline bool cgroup_is_dead(const struct cgroup *cgrp)
{
	return !(cgrp->self.flags & CSS_ONLINE);
}

static int __init cg_cleaner_init(void)
{
	struct cgroup_subsys_state *(*css_next_descendant_pre)(struct cgroup_subsys_state *pos, struct cgroup_subsys_state *root);
	struct cgroup_subsys_state *css;
	struct mutex *cgroup_mutex;
	struct cgroup *cgrp;

	cgroup_mutex = lookup_name("cgroup_mutex");
	css_next_descendant_pre = lookup_name("css_next_descendant_pre");
	if (!cgroup_mutex || !css_next_descendant_pre)
		return 0;

	mutex_lock(cgroup_mutex);

	cgrp = &cgrp_dfl_root.cgrp;
	css_for_each_descendant_pre(css, &cgrp->self) {
		struct cgroup *desc = container_of(css, struct cgroup, self);

		if (cgroup_on_dfl(desc) && cgroup_is_dead(desc)) {
			printk("Free dead cgroup %d", desc->id);
			cgroup_put(desc);
		}
	}

	mutex_unlock(cgroup_mutex);

	return 0;
}

static void __exit cg_cleaner_exit(void)
{
}

module_init(cg_cleaner_init);
module_exit(cg_cleaner_exit);
