#!/bin/bash

set -e

DIR=$(dirname $0)
cd $DIR

version=$1
resource_id=$2
version_majmin=$(echo $version | cut -d '.' -f 1-2)
SBCTL=${SBCTL:-$(../../../ya tool sandboxctl --print-path)}


usage(){
    echo "Usage $0 kernel_release [kvm_init_resource]"
}

die() {
    echo $1
    exit 1
}

if [ -z "$1" -o "$1" == "--help" -o "$1" == "-h" ]
then
    usage
    exit 1
fi


test -z "$version_majmin" && die "bad kernel version $version"
test -d $version_majmin/$version && die "release directory $(pwd)/$version_majmin/$version already exists"

build_kvm_initrd() {
    task_id=$($SBCTL ya-make \
		     -q \
		     -c definition_flags=-DKVM_KERNEL_VERSION=${1} \
		     -c resource_archive_check=true \
		     -c release_on_success=true \
		     -u trunk \
		     ../tools/kvm_kernel/kvm-kernel.tar.gz)
    
    $SBCTL get_task -q --wait $task_id > /dev/null
    
    res_id=$($SBCTL list_resource -q  --task_id $task_id \
                         --type ARCADIA_PROJECT_TGZ \
                         -A arcadia_path=infra/kernel/tools/kvm_kernel/kvm-kernel.tar.gz)
    echo $res_id
}



if [ -z "$resource_id" ]; then
    resource_id=$(build_kvm_initrd $version)
fi

mkdir $version_majmin/$version
cp -vr template/* $version_majmin/$version/
sed -i "s/RECURSE(/RECURSE(\n    $version/g" $version_majmin/ya.make

sed -i "s/FIX_ME_RESOURCE_ID/$resource_id/g" $version_majmin/$version/ya.make
sed -i "s/FIX_ME_KERNEL_VERSION/$version/g" $version_majmin/$version/ya.make.autoupdate
arc add $version_majmin/ya.make \
        $version_majmin/$version/ya.make  \
        $version_majmin/$version/ya.make.autoupdate
exit 0
