IF (NOT AUTOCHECK)

PACKAGE()
OWNER(g:kernel)

SET(VERSION stable.git-v5.10)
SET(SRC_RESOURCE 2551444539)
SET(SRC_TARBALL linux-${VERSION}.tar.gz)
SET(OUT_TARBALL bpftool-static.tar.gz)

INCLUDE(${ARCADIA_ROOT}/infra/qemu/vmexec/env.inc)

PEERDIR(
    ${QEMU_BIN_ROOT}
    ${VMEXEC_DEF_ROOTFS}
)

FROM_SANDBOX(
    FILE ${SRC_RESOURCE}
    OUT ${SRC_TARBALL}
)

RUN_PROGRAM(
    infra/qemu/vmexec -S ${ARCADIA_ROOT} -B ${ARCADIA_BUILD_ROOT} --vcpu 8 --mem 8G  --
                   build.py build --install-deps ${SRC_TARBALL} ${OUT_TARBALL}
    CWD ${BINDIR}
    IN build.py
       ${SRC_TARBALL}
       ${QEMU_BIN_APP}
       ${VMEXEC_DEF_ROOTFS}/rootfs.img

    OUT_NOAUTO ${OUT_TARBALL}
    STDOUT_NOAUTO build.log
)

END()

ENDIF()
