#!/bin/bash

if [ -n "$1" ] ; then
	dev=$1
else
	dev=$(ip -6 route | grep default | sed -ne 's#.*dev\s\(\S\+\).*#\1#p' | head -1)
fi

exec 2>&1
set -x

hostname
uname -r
cat /proc/cmdline
uptime

sysctl net

ip route
ip -6 route

ip rule
ip route show table all
ip -6 route show table all

ip neigh show proxy dev $dev

iptables-save | wc
ip6tables-save | wc

ip -s -d addr show dev $dev
ip -s -d link show dev $dev
tc -s -d qdisc show dev $dev
tc -s -d class show dev $dev
tc -s -d filter show dev $dev

cat /proc/net/sockstat
cat /proc/net/sockstat6
cat /proc/net/protocols

for irq in $(cat /sys/class/net/$dev/device/irq) $(ls /sys/class/net/$dev/device/msi_irqs) ; do
	head /proc/irq/$irq/smp_affinity
done
cat /proc/interrupts
head /sys/class/net/$dev/queues/rx-*/rps_cpus
head /sys/class/net/$dev/queues/rx-*/rps_flow_cnt
head /sys/class/net/$dev/queues/tx-*/xps_cpus

cat /sys/class/net/$dev/speed
head /sys/class/net/$dev/statistics/*

ethtool -i $dev
ethtool -k $dev
ethtool -l $dev
ethtool -g $dev
ethtool -c $dev
ethtool -n $dev
ethtool -S $dev
